/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.io;

import java.math.BigInteger;
import net.wicp.tams.common.apiext.ByteUtil;

public abstract class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    private static final long serialVersionUID = 1L;
    private static final UnsignedLong[] CACHE = new UnsignedLong[255];

    public boolean equals(Object obj) {
        if (!(obj instanceof UnsignedLong)) {
            return false;
        }
        return this.doubleValue() == ((UnsignedLong)obj).doubleValue();
    }

    @Override
    public int compareTo(UnsignedLong rhs) {
        return this.doubleValue() < rhs.doubleValue() ? -1 : (this.doubleValue() == rhs.doubleValue() ? 0 : 1);
    }

    public static final UnsignedLong valueOf(long value) {
        if (value < 0L) {
            return new UnsignedLongUnlimited(value);
        }
        if (value < (long)CACHE.length) {
            return CACHE[(int)value];
        }
        if (value < Integer.MAX_VALUE) {
            return new UnsignedLong4((int)value);
        }
        return new UnsignedLong8(value);
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            UnsignedLong.CACHE[i] = new UnsignedLong4(i);
        }
    }

    private static final class UnsignedLongUnlimited
    extends UnsignedLong {
        private static final long serialVersionUID = -5362638763306527191L;
        private final BigInteger value;

        private UnsignedLongUnlimited(long value) {
            this.value = new BigInteger(1, ByteUtil.toByteArray(value));
        }

        @Override
        public int intValue() {
            return this.value.intValue();
        }

        @Override
        public long longValue() {
            return this.value.longValue();
        }

        @Override
        public float floatValue() {
            return this.value.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.value.doubleValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static final class UnsignedLong8
    extends UnsignedLong {
        private static final long serialVersionUID = -314206857441911721L;
        private final long value;

        private UnsignedLong8(long value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }
    }

    private static final class UnsignedLong4
    extends UnsignedLong {
        private static final long serialVersionUID = 6549354506227481646L;
        private final int value;

        private UnsignedLong4(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public int hashCode() {
            return this.value;
        }
    }
}

