/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.beans;

public class Host
implements Comparable<Host> {
    public static final String preVar = "host";
    private String hostIp;
    private int port;
    private String userName;
    private String password;

    public Host() {
    }

    public Host(String hostIp, int port, String userName, String password) {
        this.hostIp = hostIp;
        this.port = port;
        this.userName = userName;
        this.password = password;
    }

    public static Host fromParts(String hostIp, int port) {
        return Host.builder().hostIp(hostIp).port(port).build();
    }

    public Host(String hostIp, int port) {
        this(hostIp, port, null, null);
    }

    public boolean equals(Object obj) {
        Host temp = (Host)obj;
        return this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort();
    }

    public int hashCode() {
        return this.hostIp.hashCode() * 37 + this.port;
    }

    @Override
    public int compareTo(Host o) {
        String[] ips1 = this.hostIp.split(".");
        String[] ips2 = o.getHostIp().split(".");
        for (int i = 0; i < 4; ++i) {
            int si2;
            int si1 = Integer.parseInt(ips1[i]);
            if (si1 == (si2 = Integer.parseInt(ips2[i]))) continue;
            return si1 - si2;
        }
        return this.port - o.getPort();
    }

    public static HostBuilder builder() {
        return new HostBuilder();
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "Host(hostIp=" + this.getHostIp() + ", port=" + this.getPort() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ")";
    }

    public static class HostBuilder {
        private String hostIp;
        private int port;
        private String userName;
        private String password;

        HostBuilder() {
        }

        public HostBuilder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public HostBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HostBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public HostBuilder password(String password) {
            this.password = password;
            return this;
        }

        public Host build() {
            return new Host(this.hostIp, this.port, this.userName, this.password);
        }

        public String toString() {
            return "Host.HostBuilder(hostIp=" + this.hostIp + ", port=" + this.port + ", userName=" + this.userName + ", password=" + this.password + ")";
        }
    }
}

