/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ClassHelper;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectAssist {
    private static final Logger log = LoggerFactory.getLogger(ReflectAssist.class);
    private static String[] excludeGet = new String[]{"getClass"};
    public static final char JVM_VOID = 'V';
    public static final char JVM_BOOLEAN = 'Z';
    public static final char JVM_BYTE = 'B';
    public static final char JVM_CHAR = 'C';
    public static final char JVM_DOUBLE = 'D';
    public static final char JVM_FLOAT = 'F';
    public static final char JVM_INT = 'I';
    public static final char JVM_LONG = 'J';
    public static final char JVM_SHORT = 'S';
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String JAVA_IDENT_REGEX = "(?:[_$a-zA-Z][_$a-zA-Z0-9]*)";
    public static final String JAVA_NAME_REGEX = "(?:(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\.(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*)";
    public static final String CLASS_DESC = "(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)";
    public static final String ARRAY_DESC = "(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)))";
    public static final String DESC_REGEX = "(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;))))";
    public static final Pattern DESC_PATTERN = Pattern.compile("(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;))))");
    public static final String METHOD_DESC_REGEX = "(?:((?:[_$a-zA-Z][_$a-zA-Z0-9]*))?\\(((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;))))*)\\)((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)))))?)";
    public static final Pattern METHOD_DESC_PATTERN = Pattern.compile("(?:((?:[_$a-zA-Z][_$a-zA-Z0-9]*))?\\(((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;))))*)\\)((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)))))?)");
    public static final Pattern GETTER_METHOD_DESC_PATTERN = Pattern.compile("get([A-Z][_a-zA-Z0-9]*)\\(\\)((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)))))");
    public static final Pattern SETTER_METHOD_DESC_PATTERN = Pattern.compile("set([A-Z][_a-zA-Z0-9]*)\\(((?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)|(?:\\[+(?:(?:[VZBCDFIJS])|(?:L(?:[_$a-zA-Z][_$a-zA-Z0-9]*)(?:\\/(?:[_$a-zA-Z][_$a-zA-Z0-9]*))*;)))))\\)V");
    public static final Pattern IS_HAS_CAN_METHOD_DESC_PATTERN = Pattern.compile("(?:is|has|can)([A-Z][_a-zA-Z0-9]*)\\(\\)Z");
    private static final ConcurrentMap<String, Class<?>> NAME_CLASS_CACHE = new ConcurrentHashMap();

    public static Object getPrivateField(Object bean, String fieldName) {
        Field field = null;
        try {
            field = bean.getClass().getDeclaredField(fieldName);
        }
        catch (Exception e) {
            log.error("get   field:[{}]  from class:[{}] error", (Object)fieldName, (Object)bean.getClass().getName());
            Class<?> superclass = bean.getClass().getSuperclass();
            try {
                field = superclass.getDeclaredField(fieldName);
            }
            catch (Exception e2) {
                log.error("get   field:[{}]  from super class:[{}] error", (Object)fieldName, (Object)superclass.getName());
                return null;
            }
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            Object retobj = field.get(bean);
            return retobj;
        }
        catch (Exception e) {
            log.error("get object error", (Throwable)e);
            return null;
        }
    }

    public static Object invokeStaticMothed(String className, String methodName, Class[] paramclass, Object ... param) throws Exception {
        Class<?> c = Class.forName(className);
        Method m = c.getMethod(methodName, paramclass);
        Object retobj = m.invoke(c, param);
        return retobj;
    }

    public static Object invokeStaticMothed(String className, String methodName, Object ... param) throws Exception {
        Class[] paramClass = null;
        if (!ArrayUtils.isEmpty((Object[])param)) {
            paramClass = new Class[param.length];
            for (int i = 0; i < param.length; ++i) {
                paramClass[i] = param.getClass();
            }
        }
        return ReflectAssist.invokeStaticMothed(className, methodName, paramClass, param);
    }

    public static Object invokeMothed(Object invokeObj, String methodName, Object ... param) {
        Class<?> c = invokeObj.getClass();
        if (StringUtil.isNull(methodName)) {
            log.error("\u53cd\u5c04\u4e2d\u7f3a\u5c11\u65b9\u6cd5");
            return null;
        }
        Method[] m = c.getMethods();
        Method exeMethod = null;
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] classAry;
            Method tempMethod = m[i];
            if (!methodName.equals(tempMethod.getName()) || (classAry = tempMethod.getParameterTypes()).length != param.length) continue;
            if (param == null && classAry == null || classAry.length == 0 && param.length == 0) {
                exeMethod = tempMethod;
                break;
            }
            boolean isthisMethod = true;
            for (int j = 1; j < classAry.length; ++j) {
                Class<?> classAryEle = classAry[j];
                Object paramEle = param[j];
                if (classAryEle.isArray() && paramEle.getClass().isArray()) {
                    try {
                        Object[] paramArry = param;
                        Object[] classInstArry = (Object[])classAryEle.newInstance();
                        if (!paramArry[0].getClass().isAssignableFrom(classInstArry[0].getClass())) continue;
                        isthisMethod = false;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!paramEle.getClass().isArray() && !classAryEle.isArray()) {
                    if (paramEle.getClass().isAssignableFrom(classAryEle)) continue;
                    isthisMethod = false;
                    break;
                }
                isthisMethod = false;
                break;
            }
            if (!isthisMethod) continue;
            exeMethod = tempMethod;
            break;
        }
        if (exeMethod != null) {
            try {
                return exeMethod.invoke(invokeObj, param);
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519\u3002");
            }
        }
        return null;
    }

    public static boolean isPrimitieClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> findGetMethod(Class clz) {
        ArrayList<String> methList = new ArrayList<String>();
        Method[] m = clz.getMethods();
        if (m.length == 0) {
            return methList;
        }
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] classAry;
            Method method = m[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get") || ArrayUtils.contains((Object[])excludeGet, (Object)methodName) || (classAry = method.getParameterTypes()).length != 0) continue;
            methList.add(method.getName());
        }
        return methList;
    }

    public static List<String> findGetField(Class clz) {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> methodList = ReflectAssist.findGetMethod(clz);
        for (String methodname : methodList) {
            String ele = methodname.substring(3);
            retList.add(ele.substring(0, 1).toLowerCase() + ele.substring(1));
        }
        return retList;
    }

    public static Map<String, String> convertMapFromBeanForConvert(Object obj, Map<String, IConvertValue> convermap, boolean allowNull) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        if (obj == null) {
            return retmap;
        }
        List<String> fields = ReflectAssist.findGetField(obj.getClass());
        if (CollectionUtils.isNotEmpty(fields)) {
            for (String field : fields) {
                try {
                    String value = null;
                    if (convermap == null || !convermap.containsKey(field)) {
                        value = BeanUtils.getProperty((Object)obj, (String)field);
                    } else {
                        IConvertValue convert = convermap.get(field);
                        if (convert != null) {
                            Object oriDate = PropertyUtils.getProperty((Object)obj, (String)field);
                            value = convert.getStr(oriDate);
                        } else {
                            value = BeanUtils.getProperty((Object)obj, (String)field);
                        }
                    }
                    if (!allowNull && StringUtil.isNull(value) || StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) continue;
                    retmap.put(field, value);
                }
                catch (Exception exception) {}
            }
        }
        return retmap;
    }

    public static <T extends Serializable> Map<String, String> convertMapFromBean(T obj) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        if (obj == null) {
            return retmap;
        }
        List<String> fields = ReflectAssist.findGetField(obj.getClass());
        if (CollectionUtils.isNotEmpty(fields)) {
            for (String field : fields) {
                ReflectAssist.packMap(retmap, null, obj, field);
            }
        }
        return retmap;
    }

    private static void packMap(Map<String, String> map, String oldfield, Object obj, String field) {
        String key = StringUtil.isNull(oldfield) ? field : String.format("%s.%s", oldfield, field);
        Object fieldObj = null;
        try {
            fieldObj = PropertyUtils.getProperty((Object)obj, (String)field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fieldObj == null) {
            return;
        }
        if (ReflectAssist.isPrimitieClass(fieldObj.getClass()) || fieldObj instanceof String || fieldObj instanceof Enum) {
            String value = String.valueOf(fieldObj);
            if (StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) {
                return;
            }
            map.put(key, value);
        } else if (fieldObj instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.US);
            String datestr = sdf.format(fieldObj);
            map.put(key, datestr);
        } else {
            List<String> fields = ReflectAssist.findGetField(fieldObj.getClass());
            if (CollectionUtils.isNotEmpty(fields)) {
                for (String subFields : fields) {
                    ReflectAssist.packMap(map, key, fieldObj, subFields);
                }
            }
        }
    }

    public static <T extends Serializable> T convertMapToBean(Class clazz, Map<String, String> valueMap) {
        if (MapUtils.isEmpty(valueMap)) {
            return null;
        }
        try {
            Serializable t = (Serializable)clazz.newInstance();
            for (String key : valueMap.keySet()) {
                String value = valueMap.get(key);
                StringUtil.packObj(t, key, value);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public static boolean isInterface(Class classz, String szInterface) {
        if (classz.getName().equals(szInterface)) {
            return true;
        }
        Class<?>[] face = classz.getInterfaces();
        int j = face.length;
        for (int i = 0; i < j; ++i) {
            if (face[i].getName().equals(szInterface)) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            for (int x = 0; x < face1.length; ++x) {
                if (face1[x].getName().equals(szInterface)) {
                    return true;
                }
                if (!ReflectAssist.isInterface(face1[x], szInterface)) continue;
                return true;
            }
        }
        if (null != classz.getSuperclass()) {
            return ReflectAssist.isInterface(classz.getSuperclass(), szInterface);
        }
        return false;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static Class getClassRefType(PropertyDescriptor propertyDescriptor) {
        Field[] fields = propertyDescriptor.getClass().getSuperclass().getDeclaredFields();
        if (fields == null || fields.length <= 0) {
            return null;
        }
        for (Field field : fields) {
            if (!"classRef".equals(field.getName())) continue;
            try {
                field.setAccessible(true);
                return (Class)((Reference)field.get(propertyDescriptor)).get();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Class[]> getContextType(Class classz) {
        Field[] fs = classz.getDeclaredFields();
        HashMap<String, Class[]> retMap = new HashMap<String, Class[]>();
        for (Field f : fs) {
            ParameterizedType pt;
            Type fc;
            Class<Object> fieldClazz = f.getType();
            if (fieldClazz.isPrimitive() || fieldClazz.getName().startsWith("java.lang")) continue;
            if (fieldClazz.isAssignableFrom(List.class)) {
                fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                pt = (ParameterizedType)fc;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                retMap.put(f.getName(), new Class[]{genericClazz});
                continue;
            }
            if (fieldClazz.isAssignableFrom(Map.class)) {
                fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                pt = (ParameterizedType)fc;
                Class param0 = (Class)pt.getActualTypeArguments()[0];
                Class param1 = (Class)pt.getActualTypeArguments()[1];
                retMap.put(f.getName(), new Class[]{param0, param1});
                continue;
            }
            if (!fieldClazz.isArray()) continue;
            retMap.put(f.getName(), new Class[]{fieldClazz.getComponentType()});
        }
        return retMap;
    }

    public static Result copyProperties(Object dest, Object orig) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)orig);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u5c5e\u6027\u51fa\u9519", (Throwable)e);
            return Result.getError(e.getMessage());
        }
    }

    public static void mergeObj(Object to, Object from, String ... removes) {
        ReflectAssist.mergeObj(to, from, false, false, removes);
    }

    public static void mergeObj(Object to, Object from, boolean copyNull, String ... removes) {
        ReflectAssist.mergeObj(to, from, copyNull, true, removes);
    }

    public static void mergeObj(Object to, Object from, boolean copyNull, boolean copyBlank, String ... removes) {
        if (from == null) {
            return;
        }
        List<String> fields = ReflectAssist.findGetField(from.getClass());
        for (String field : fields) {
            if (ArrayUtils.contains((Object[])removes, (Object)field)) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)from, (String)field);
                if (!copyNull && value == null || !copyBlank && StringUtil.isNull(value)) continue;
                BeanUtils.copyProperty((Object)to, (String)field, (Object)value);
            }
            catch (Exception exception) {}
        }
    }

    public static Class getSuperClassGenricType(Class clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return ReflectAssist.getSuperClassGenricType(clazz, 0);
    }

    public static <T> T newInst(Class<T> clazz) {
        try {
            Constructor<T> c0 = clazz.getDeclaredConstructor(new Class[0]);
            c0.setAccessible(true);
            T retobj = c0.newInstance(new Object[0]);
            return retobj;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    public static <T> T newInst(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)ReflectAssist.newInst(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static List<Method> findMethods(Class<?> calssZ, Class<? extends Annotation> classA) {
        Method[] methods = calssZ.getDeclaredMethods();
        ArrayList<Method> retMethods = new ArrayList<Method>();
        if (methods != null) {
            for (Method method : methods) {
                Annotation annotation = method.getAnnotation(classA);
                if (annotation == null) continue;
                retMethods.add(method);
            }
        }
        return retMethods;
    }

    public static List<Field> findFields(Class<?> calssZ, Class<? extends Annotation> classA) {
        Field[] field = calssZ.getDeclaredFields();
        ArrayList<Field> retlist = new ArrayList<Field>();
        if (field != null) {
            for (Field fie : field) {
                Annotation annotation;
                if (!fie.isAccessible()) {
                    fie.setAccessible(true);
                }
                if ((annotation = fie.getDeclaredAnnotation(classA)) == null) continue;
                retlist.add(fie);
            }
        }
        return retlist;
    }

    public static Class<?> forName(String name) {
        try {
            return ReflectAssist.name2class(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Not found class " + name + ", cause: " + e.getMessage(), e);
        }
    }

    public static Class<?> name2class(String name) throws ClassNotFoundException {
        return ReflectAssist.name2class(ClassHelper.getClassLoader(), name);
    }

    private static Class<?> name2class(ClassLoader cl, String name) throws ClassNotFoundException {
        Class<?> clazz;
        int c = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        if (c > 0) {
            StringBuilder sb = new StringBuilder();
            while (c-- > 0) {
                sb.append("[");
            }
            if ("void".equals(name)) {
                sb.append('V');
            } else if ("boolean".equals(name)) {
                sb.append('Z');
            } else if ("byte".equals(name)) {
                sb.append('B');
            } else if ("char".equals(name)) {
                sb.append('C');
            } else if ("double".equals(name)) {
                sb.append('D');
            } else if ("float".equals(name)) {
                sb.append('F');
            } else if ("int".equals(name)) {
                sb.append('I');
            } else if ("long".equals(name)) {
                sb.append('J');
            } else if ("short".equals(name)) {
                sb.append('S');
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        } else {
            if ("void".equals(name)) {
                return Void.TYPE;
            }
            if ("boolean".equals(name)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(name)) {
                return Byte.TYPE;
            }
            if ("char".equals(name)) {
                return Character.TYPE;
            }
            if ("double".equals(name)) {
                return Double.TYPE;
            }
            if ("float".equals(name)) {
                return Float.TYPE;
            }
            if ("int".equals(name)) {
                return Integer.TYPE;
            }
            if ("long".equals(name)) {
                return Long.TYPE;
            }
            if ("short".equals(name)) {
                return Short.TYPE;
            }
        }
        if (cl == null) {
            cl = ClassHelper.getClassLoader();
        }
        if ((clazz = (Class<?>)NAME_CLASS_CACHE.get(name)) == null) {
            clazz = Class.forName(name, true, cl);
            NAME_CLASS_CACHE.put(name, clazz);
        }
        return clazz;
    }
}

