/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.annotation.complier;

import java.util.EnumSet;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementScanner7;
import javax.tools.Diagnostic;

public class NameChecker {
    private final Messager messager;
    NameCheckScanner nameCheckScanner = new NameCheckScanner();

    NameChecker(ProcessingEnvironment processsingEnv) {
        this.messager = processsingEnv.getMessager();
    }

    public void checkNames(Element element) {
        this.nameCheckScanner.scan(element);
    }

    private class NameCheckScanner
    extends ElementScanner7<Void, Void> {
        private NameCheckScanner() {
        }

        @Override
        public Void visitType(TypeElement e, Void p) {
            this.scan(e.getTypeParameters(), p);
            this.checkCamelCase(e, true);
            super.visitType(e, p);
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Void p) {
            if (e.getKind() == ElementKind.METHOD) {
                Name name = e.getSimpleName();
                if (name.contentEquals(e.getEnclosingElement().getSimpleName())) {
                    NameChecker.this.messager.printMessage(Diagnostic.Kind.WARNING, "\u4e00\u4e2a\u666e\u901a\u65b9\u6cd5'" + name + "'\u4e0d\u5e94\u5f53\u4e0e\u7c7b\u540d\u91cd\u590d,\u907f\u514d\u4e0e\u6784\u9020\u51fd\u6570\u4ea7\u751f\u6df7\u6dc6", e);
                }
                this.checkCamelCase(e, false);
            }
            super.visitExecutable(e, p);
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Void p) {
            if (e.getKind() == ElementKind.ENUM_CONSTANT || e.getConstantValue() != null || this.heuristicallyConstant(e)) {
                this.checkAllCaps(e);
            } else {
                this.checkCamelCase(e, false);
            }
            return null;
        }

        private boolean heuristicallyConstant(VariableElement e) {
            if (e.getEnclosingElement().getKind() == ElementKind.INTERFACE) {
                return true;
            }
            return e.getKind() == ElementKind.FIELD && e.getModifiers().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL));
        }

        private void checkCamelCase(Element e, boolean initialCaps) {
            String name = e.getSimpleName().toString();
            boolean previousUpper = false;
            boolean conventional = true;
            int firstCodePoint = name.codePointAt(0);
            if (Character.isUpperCase(firstCodePoint)) {
                previousUpper = true;
                if (!initialCaps) {
                    NameChecker.this.messager.printMessage(Diagnostic.Kind.WARNING, "\u540d\u79f0'" + name + "'\u5e94\u5f53\u4ee5\u5c0f\u5199\u5b57\u6bcd\u5f00\u5934", e);
                    return;
                }
            } else if (Character.isLowerCase(firstCodePoint)) {
                if (initialCaps) {
                    NameChecker.this.messager.printMessage(Diagnostic.Kind.WARNING, "\u540d\u79f0'" + name + "'\u5e94\u5f53\u4ee5\u5927\u5199\u5b57\u6bcd\u5f00\u5934", e);
                    return;
                }
            } else {
                conventional = false;
            }
            if (conventional) {
                int cp = firstCodePoint;
                for (int i = Character.charCount(cp); i < name.length(); i += Character.charCount(cp)) {
                    cp = name.codePointAt(i);
                    if (Character.isUpperCase(cp)) {
                        if (previousUpper) {
                            conventional = false;
                            break;
                        }
                        previousUpper = true;
                        continue;
                    }
                    previousUpper = false;
                }
            }
            if (!conventional) {
                NameChecker.this.messager.printMessage(Diagnostic.Kind.WARNING, "\u540d\u79f0'" + name + "'\u5e94\u5f53\u7b26\u5408\u9a7c\u5f0f\u547d\u540d\u6cd5(Camel Case Names)", e);
            }
        }

        private void checkAllCaps(Element e) {
            String name = e.getSimpleName().toString();
            boolean conventional = true;
            int firstCodePoint = name.codePointAt(0);
            if (!Character.isUpperCase(firstCodePoint)) {
                conventional = false;
            } else {
                boolean previousUnderscore = false;
                int cp = firstCodePoint;
                for (int i = Character.charCount(cp); i < name.length(); i += Character.charCount(cp)) {
                    cp = name.codePointAt(i);
                    if (cp == 95) {
                        if (previousUnderscore) {
                            conventional = false;
                            break;
                        }
                        previousUnderscore = true;
                        continue;
                    }
                    previousUnderscore = false;
                    if (Character.isUpperCase(cp) || Character.isDigit(cp)) continue;
                    conventional = false;
                    break;
                }
            }
            if (!conventional) {
                NameChecker.this.messager.printMessage(Diagnostic.Kind.WARNING, "\u5e38\u91cf'" + name + "'\u5e94\u5f53\u5168\u90e8\u4ee5\u5927\u5199\u5b57\u6bcd\u6216\u4e0b\u5212\u7ebf\u547d\u540d,\u5e76\u4e14\u4ee5\u5b57\u6bcd\u5f00\u5934", e);
            }
        }
    }
}

