/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import com.google.protobuf.ProtocolStringList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MySqlAssit {
    private static final Logger log = LoggerFactory.getLogger(MySqlAssit.class);

    public static String getColsForQuery(String[] cols) {
        String colsstr = "`" + CollectionUtil.arrayJoin(cols, "`,`") + "`";
        return colsstr;
    }

    public static Result dataUpset(Connection conn, String db, String tb, Object[][] datas, String[] cols, String[] keys, BinlogType[] typeAry, boolean isUpset) {
        int i;
        Object[][] priDatas = new Object[datas.length][];
        if (isUpset) {
            if (ArrayUtils.isEmpty((Object[])keys)) {
                keys = MySqlAssit.getPrimary(conn, db, tb);
            }
            if (!ArrayUtils.isEmpty((Object[])keys)) {
                StringBuilder builder = new StringBuilder(String.format("delete from %s.%s where 1=1", db, tb));
                for (String key : keys) {
                    builder.append(String.format(" and %s=?", key));
                }
                try {
                    conn.setAutoCommit(false);
                    PreparedStatement stmtDel = conn.prepareStatement(builder.toString());
                    int[] keyindex = new int[keys.length];
                    for (i = 0; i < keys.length; ++i) {
                        keyindex[i] = ArrayUtils.indexOf((Object[])cols, (Object)keys[i]);
                    }
                    for (i = 0; i < datas.length; ++i) {
                        Object[] keysValue = new Object[keys.length];
                        priDatas[i] = keysValue;
                        for (int j = 0; j < keysValue.length; ++j) {
                            keysValue[j] = datas[i][keyindex[j]];
                        }
                        JdbcAssit.setPreParam(stmtDel, null, keysValue);
                        stmtDel.addBatch();
                    }
                    stmtDel.executeBatch();
                    stmtDel.close();
                }
                catch (SQLException e) {
                    log.error("\u5220\u9664\u4e3b\u952e\u5931\u8d25", (Throwable)e);
                    return new Result(new ProjectException((IExcept)ExceptAll.jdbc_exec_fail, ""));
                }
            }
        }
        try {
            Object[] tempAry = new String[cols.length];
            for (int i2 = 0; i2 < tempAry.length; ++i2) {
                tempAry[i2] = "?";
            }
            String sql = String.format("insert into %s.%s (%s) values (%s)", db, tb, MySqlAssit.getColsForQuery(cols), CollectionUtil.arrayJoin(tempAry, ","));
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement(sql);
            stmt.clearBatch();
            for (i = 0; i < datas.length; ++i) {
                int indexOf;
                if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                JdbcAssit.setPreParam(stmt, typeAry, datas[i]);
                stmt.addBatch();
            }
            stmt.executeBatch();
            conn.commit();
            stmt.close();
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25", (Throwable)e);
            return new Result(ExceptAll.jdbc_exec_fail);
        }
    }

    public static Result dataUpset(Connection conn, JdbcDatas datas, boolean isUpset) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getColsCount()];
            for (int j = 0; j < datas.getColsCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getCols(j));
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        Map<String, String> typeMap = datas.getTypeMap();
        ProtocolStringList colsList = datas.getColsList();
        BinlogType[] typeAry = new BinlogType[colsList.size()];
        for (int i = 0; i < typeAry.length; ++i) {
            typeAry[i] = BinlogType.valueOf(typeMap.get(colsList.get(i)));
        }
        return MySqlAssit.dataUpset(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getColsList().toArray((Object[])new String[datas.getColsList().size()]), (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]), typeAry, isUpset);
    }

    public static Result dataDelete(Connection conn, String db, String tb, Object[][] datas, String[] keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            keys = MySqlAssit.getPrimary(conn, db, tb);
        }
        if (!ArrayUtils.isEmpty((Object[])keys)) {
            StringBuilder builder = new StringBuilder(String.format("delete from %s.%s where 1=1", db, tb));
            for (String key : keys) {
                builder.append(String.format(" and %s=?", key));
            }
            try {
                conn.setAutoCommit(false);
                PreparedStatement stmtDel = conn.prepareStatement(builder.toString());
                for (int i = 0; i < datas.length; ++i) {
                    JdbcAssit.setPreParam(stmtDel, null, datas[i]);
                    stmtDel.addBatch();
                }
                stmtDel.executeBatch();
                conn.commit();
                stmtDel.close();
                return Result.getSuc();
            }
            catch (SQLException e) {
                log.error("\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25", (Throwable)e);
                return new Result(new ProjectException((IExcept)ExceptAll.jdbc_exec_fail, "\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25"));
            }
        }
        throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail);
    }

    public static Result dataDelete(Connection conn, JdbcDatas datas) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getKeysCount()];
            for (int j = 0; j < datas.getKeysCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getKeys(j));
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getKeys(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        return MySqlAssit.dataDelete(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]));
    }

    public static Result dataChange(Connection conn, JdbcDatas datas) {
        if (datas.getOptType() == OptType.delete) {
            return MySqlAssit.dataDelete(conn, datas);
        }
        return MySqlAssit.dataUpset(conn, datas, true);
    }

    public static String[] getPrimary(Connection conn, String db, String tb) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
            JdbcAssit.setPreParam(preparedStatement, null, new Object[]{db, tb});
            ResultSet rs2 = preparedStatement.executeQuery();
            if (!rs2.next()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            ArrayList<String> retlist = new ArrayList<String>();
            retlist.add(rs2.getString(1));
            while (rs2.next()) {
                retlist.add(rs2.getString(1));
            }
            String[] stringArray = retlist.toArray(new String[retlist.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            log.error("\u67e5\u4e3b\u952e\u5931\u8d25");
            throw new ProjectExceptionRuntime(ExceptAll.jdbc_query_primary);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e2) {
                log.error("\u5173\u95edpreparedStatement\u5931\u8d25", (Throwable)e2);
            }
        }
    }

    public static String[][] getCols(Connection conn, String db, String tb, YesOrNo isRds) {
        try {
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=?");
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcAssit.setPreParam(prepCols, null, new Object[]{db, tb});
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (YesOrNo.yes == isRds && ArrayUtils.isEmpty((Object[])MySqlAssit.getPrimary(conn, db, tb))) {
                ret.add("_rowkey_");
                retType.add("varchar");
            }
            String[][] retAry = new String[2][ret.size()];
            retAry[0] = ret.toArray(new String[ret.size()]);
            retAry[1] = retType.toArray(new String[retType.size()]);
            String[][] stringArray = retAry;
            return stringArray;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }
}

