package net.wicp.tams.common.thread.threadlocal;

/**
 * 
 * @author 偏锋书生
 *
 */
public interface PerThreadValue<T> {
	/**
	 * Is a value stored (even null)?
	 */
	boolean exists();

	/**
	 * Reads the current per-thread value, or returns null if no value has been
	 * stored.
	 */
	T get();

	/**
	 * Gets the current per-thread value if it exists (even if null), or the
	 * defaultValue if no value has been stored.
	 */
	T get(T defaultValue);

	/**
	 * Sets the current per-thread value, then returns that value.
	 */
	T set(T newValue);
}
