package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.IOUtil;

/****
 * maven项目的文件
 * 
 * @author andy.zhou
 *
 */
public enum BasePath {
	root("项目根目录", "/"),

	java("java代码根目录", "/src/main/java/"),

	source("source根目录", "/src/main/resources/"),

	target("编译根目录", "/target"),

	classRoot("根目录，在classLoad里用它", "/target/classes");

	public static String projectBasePath;
	private final String desc;
	private final String path;

	private BasePath(String desc, String path) {
		this.desc = desc;
		this.path = path;
	}

	public String getDesc() {
		return desc;
	}

	public String getPath() {
		return IOUtil.mergeFolderAndFilePath(projectBasePath, path);
	}
}
