package net.wicp.tams.common.apiext;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

import net.wicp.tams.common.Conf;
/**
 * 
 * @author 偏锋书生
 *
 */
public class SocketUtil {

	public static Socket create(String host, int port) throws UnknownHostException, IOException {
		final Socket r = new Socket(host, port);
		r.setKeepAlive(Boolean.parseBoolean(Conf.get("common.apiext.socket.keepalive")));
		r.setTcpNoDelay(Boolean.parseBoolean(Conf.get("common.apiext.socket.tcpnodelay")));
		r.setSoLinger(true, 0);
		int receiveBufferSize = Integer.parseInt(Conf.get("common.apiext.socket.receivebuffersize"));
		if (receiveBufferSize > 0)
			r.setReceiveBufferSize(receiveBufferSize);
		return r;
	}
}
