package net.wicp.tams.common.apiext.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.constant.dic.YesOrNo;

@Slf4j
public abstract class MySqlUtil {

	public static String[][] getCols(String ip, int port, String user, String pwd, String db, String tb, YesOrNo isRds,
			YesOrNo isSsh) {
		java.sql.Connection conn = null;
		try {
			String url;
			if (isSsh != null && isSsh == YesOrNo.yes) {
				SshAssist.ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")),ip,port);
				url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8",
						"localhost", Conf.get("common.apiext.ssh.proxy.localhost.port"));
			} else {
				url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", ip,
						port);
			}
			conn = JdbcUtil.getConnection("com.mysql.jdbc.Driver", url, user, pwd);
			PreparedStatement prepCols = conn.prepareStatement(
					"select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=?");

			List<String> ret = new ArrayList<>();
			List<String> retType = new ArrayList<>();
			JdbcUtil.setPreParam(prepCols, db, tb);
			ResultSet rs = prepCols.executeQuery();
			while (rs.next()) {
				ret.add(rs.getString(1));
				retType.add(rs.getString(2));
			}
			rs.close();
			if (YesOrNo.yes == isRds) {// 是rds
				PreparedStatement prepRowkey = conn.prepareStatement(
						"SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
				JdbcUtil.setPreParam(prepRowkey, db, tb);
				ResultSet rs2 = prepRowkey.executeQuery();
				if (!rs2.next()) {
					ret.add("_rowkey_");
					retType.add("varchar");
				}
				rs2.close();
			}
			String[][] retAry = new String[2][ret.size()];
			retAry[0] = ret.toArray(new String[ret.size()]);
			retAry[1] = retType.toArray(new String[retType.size()]);
			return retAry;
		} catch (Exception e) {
			log.error("获取cols错误", e);
			throw new RuntimeException("获取cols错误");
		} finally {
			if (conn != null) {
				try {
					conn.close();
				} catch (SQLException e) {
					log.error("关闭连接失败", e);
				}
			}
		}
	}
}
