/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant.dbType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;

public enum BinlogType {
    DECIMAL(0, new String[0]),
    TINY(1, new String[]{"tinyint"}),
    SHORT(2, new String[]{"smallint"}),
    LONG(3, new String[]{"int", "integer(int)"}),
    FLOAT(4, new String[]{"float"}),
    DOUBLE(5, new String[]{"real(double)", "double"}),
    NULL(6, new String[0]),
    TIMESTAMP(7, new String[0]),
    LONGLONG(8, new String[]{"bigint"}),
    INT24(9, new String[]{"mediumint"}),
    DATE(10, new String[]{"date"}),
    TIME(11, new String[0]),
    DATETIME(12, new String[0]),
    YEAR(13, new String[]{"year"}),
    NEWDATE(14, new String[0]),
    VARCHAR(15, new String[]{"varchar", "varbinary", "varchar(8000)"}),
    BIT(16, new String[]{"bit"}),
    TIMESTAMP2(17, new String[]{"timestamp"}),
    DATETIME2(18, new String[]{"datetime"}),
    TIME2(19, new String[]{"time"}),
    JSON(245, new String[0]),
    NEWDECIMAL(246, new String[]{"decimal", "numeric(decimal)"}),
    ENUM(247, new String[0]),
    SET(248, new String[0]),
    TINY_BLOB(249, new String[0]),
    MEDIUM_BLOB(250, new String[0]),
    LONG_BLOB(251, new String[0]),
    BLOB(252, new String[]{"tinyblob", "blob", "mediumblob", "longblob", "tinytext", "text", "mediumtext", "longtext"}),
    VAR_STRING(253, new String[0]),
    STRING(254, new String[]{"char", "enum('e3','e2','e1')", "set('s1','s3','s2')", "binary"}),
    GEOMETRY(255, new String[]{"point", "linestring", "polygon", "geometry", "multipoint", "multilinestring", "multipolygon", "geometrycollection"}),
    UNRECOGNIZED(-1, new String[0]);

    private final int value;
    private final String[] mysqlTypes;

    public int getValue() {
        return this.value;
    }

    private BinlogType(int value, String[] mysqlTypes) {
        this.value = value;
        this.mysqlTypes = mysqlTypes;
    }

    public static BinlogType getByName(String mysqlType) {
        if (StringUtil.isNull(mysqlType)) {
            return UNRECOGNIZED;
        }
        for (BinlogType ele : BinlogType.values()) {
            if (!ArrayUtils.contains((Object[])ele.getMysqlTypes(), (Object)mysqlType)) continue;
            return ele;
        }
        return UNRECOGNIZED;
    }

    public static <T extends Serializable> T getValue(BinlogType columnType, String value) {
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case BLOB: 
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case TIMESTAMP2: 
            case DATETIME2: {
                try {
                    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    retobj = formater.parse(value);
                }
                catch (ParseException e) {
                    retobj = value;
                }
                break;
            }
            default: {
                retobj = value;
            }
        }
        return (T)retobj;
    }

    public String[] getMysqlTypes() {
        return this.mysqlTypes;
    }
}

