/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.jdbc.JdbcUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MySqlUtil {
    private static final Logger log = LoggerFactory.getLogger(MySqlUtil.class);

    public static String[][] getCols(String ip, int port, String user, String pwd, String db, String tb, YesOrNo isRds, YesOrNo isSsh) {
        Connection conn = null;
        try {
            String url;
            if (isSsh != null && isSsh == YesOrNo.yes) {
                SshAssist.ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")), ip, port);
                url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", "localhost", Conf.get("common.apiext.ssh.proxy.localhost.port"));
            } else {
                url = String.format("jdbc:mysql://%s:%s?autoReconnect=true&useUnicode=true&characterEncoding=utf-8", ip, port);
            }
            conn = JdbcUtil.getConnection("com.mysql.jdbc.Driver", url, user, pwd);
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=?");
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcUtil.setPreParam(prepCols, db, tb);
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (YesOrNo.yes == isRds) {
                PreparedStatement prepRowkey = conn.prepareStatement("SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
                JdbcUtil.setPreParam(prepRowkey, db, tb);
                ResultSet rs2 = prepRowkey.executeQuery();
                if (!rs2.next()) {
                    ret.add("_rowkey_");
                    retType.add("varchar");
                }
                rs2.close();
            }
            String[][] retAry = new String[2][ret.size()];
            retAry[0] = ret.toArray(new String[ret.size()]);
            retAry[1] = retType.toArray(new String[retType.size()]);
            String[][] stringArray = retAry;
            return stringArray;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }
}

