/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.CallbackUpdate;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.constant.Encoding;
import net.wicp.tams.common.constant.PathType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conf {
    private static final Logger log = LoggerFactory.getLogger(Conf.class);
    private static final Properties props = new Properties();
    private static final Map<String[], CallbackUpdate> reshBacks = new HashMap<String[], CallbackUpdate>();
    public static final String proPatternFomate = "^(BOOT-INF/classes/)?%s([a-zA-z0-9]-*){1,}\\.properties$";
    private static final String[] firstReads = new String[]{"common-apiext.properties", "common-connector.properties", "common-hadoop.properties", "common-http.properties", "common-micro.properties", "common-others.properties", "common-grpc.properties", "common-jdbc.properties", "common-web.properties"};
    private static Locale curLocale;

    public static void addFileFromJar(String propPath, Class classz) {
        Properties newprops = IOUtil.fileToProperties(propPath, classz);
        Conf.overProp(newprops);
    }

    public static void addCallBack(CallbackUpdate callbackupdate, String ... proNames) {
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])proNames), (String)"\u5fc5\u987b\u4f20\u8981\u8981\u68c0\u67e5\u53d8\u66f4\u7684\u5c5e\u6027\u503c", (Object[])new Object[0]);
        reshBacks.put(proNames, callbackupdate);
    }

    public static void addCallBack(CallbackUpdate callbackupdate, String pre) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)pre));
        Map<String, String> preprop = Conf.getPre(pre, false);
        Validate.isTrue((boolean)MapUtils.isNotEmpty(preprop), (String)("\u53d8\u91cf\u6ca1\u6709\u68c0\u67e5\u5230\uff0c\u8bf7\u68c0\u67e5[" + pre + "]\u5f00\u59cb\u7684\u5c5e\u6027\u662f\u5426\u6709\u914d\u7f6e"), (Object[])new Object[0]);
        Conf.addCallBack(callbackupdate, preprop.keySet().toArray(new String[preprop.size()]));
    }

    public static String get(String key) {
        return props.get(key) == null ? null : String.valueOf(props.get(key));
    }

    public static Map<String, String> getPre(String key, boolean isPure) {
        return CollectionUtil.getPropsByKeypre(props, key, isPure);
    }

    public static Properties getPreToProp(String key, boolean isPure) {
        return CollectionUtil.getPropsSubByKeypre(props, key, isPure);
    }

    public static void setCurLocale(Locale curLocale) {
        if (curLocale != null) {
            Conf.curLocale = curLocale;
        }
    }

    public static Locale getCurLocale() {
        return curLocale;
    }

    public static Properties copyProperties() {
        return (Properties)props.clone();
    }

    public static void overProp(Properties initProperties) {
        if (initProperties != null && initProperties.size() > 0) {
            for (Object keyobj : initProperties.keySet()) {
                String keystr = String.valueOf(keyobj);
                props.put(keyobj, initProperties.get(keyobj));
                System.setProperty(keystr, props.getProperty(keystr));
            }
        }
    }

    public static Encoding getSystemEncode() {
        return Encoding.getByName(System.getProperty("sun.jnu.encoding"));
    }

    public static Encoding getFileEncode() {
        return Encoding.getByName(System.getProperty("file.encoding"));
    }

    static {
        String properPattern = String.format(proPatternFomate, "common-");
        FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);
        RegexFileFilter fileFilter = new RegexFileFilter(properPattern);
        FileAlterationObserver observer = new FileAlterationObserver(new File(PathType.getPath(Conf.get("common.apiext.checkpath"))), (FileFilter)fileFilter);
        FileListerAdapter listener = new FileListerAdapter();
        observer.addListener((FileAlterationListener)listener);
        monitor.addObserver(observer);
        try {
            monitor.start();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u76d1\u63a7\u9519\u8bef", (Throwable)e);
        }
        ArrayList<InputStream> userConfs = new ArrayList<InputStream>();
        List<URL> roots = IOUtil.findHasPackRootPath("net.wicp.tams");
        for (URL root : roots) {
            List<InputStream>[] findProps = IOUtil.findProps("common-", root, "common-", firstReads);
            for (InputStream file : findProps[0]) {
                try {
                    Properties properties = new Properties();
                    properties.load(file);
                    Conf.overProp(properties);
                }
                catch (Exception e) {
                    log.error("\u8bfb\u5de5\u5177\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                }
            }
            userConfs.addAll(findProps[1]);
        }
        for (InputStream file : userConfs) {
            try {
                Properties properties = new Properties();
                properties.load(file);
                Conf.overProp(properties);
            }
            catch (Exception e) {
                log.error("\u8bfb\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
            }
        }
        log.info("confpropsize:" + props.size());
        for (Object key : props.keySet()) {
            String keystr = String.valueOf(key);
            System.setProperty(keystr, props.getProperty(keystr));
        }
        try {
            Enumeration<URL> confs = Thread.currentThread().getContextClassLoader().getResources("META-INF/tams/auto-config.json");
            while (confs.hasMoreElements()) {
                URL url = confs.nextElement();
                InputStream in = url.openStream();
                String slurp = IOUtil.slurp(in);
                JSONObject parseObject = JSONObject.parseObject((String)slurp);
                List<URL> findHasPackRootPaths = IOUtil.findHasPackRootPath(parseObject.getString("filterpack"));
                for (URL findHasPackRoot : findHasPackRootPaths) {
                    List<InputStream>[] findProps = IOUtil.findProps(parseObject.getString("properpre"), findHasPackRoot, parseObject.getString("jarpre"), parseObject.getString("firstConfs"));
                    for (InputStream file : findProps[0]) {
                        try {
                            Properties properties = new Properties();
                            properties.load(file);
                            Conf.overProp(properties);
                        }
                        catch (Exception e) {
                            log.error("\u8bfb\u5de5\u5177\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                        }
                    }
                    userConfs.addAll(findProps[1]);
                }
                for (InputStream file : userConfs) {
                    try {
                        Properties properties = new Properties();
                        properties.load(file);
                        Conf.overProp(properties);
                    }
                    catch (Exception e) {
                        log.error("\u8bfb\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("\u7528\u6237\u914d\u7f6e\u9519\u8bef", (Throwable)e);
        }
        curLocale = new Locale(Conf.get("common.apiext.i18n") == null ? "zh" : Conf.get("common.apiext.i18n"));
    }

    private static class FileListerAdapter
    extends FileAlterationListenerAdaptor {
        private FileListerAdapter() {
        }

        public void onFileChange(File file) {
            final Properties prop = IOUtil.fileToProperties(file);
            List selSet = (List)CollectionUtil.selectFilter(reshBacks.keySet(), new Predicate(){

                public boolean evaluate(Object object) {
                    Object[] tempary = (String[])object;
                    for (Object obj : prop.keySet()) {
                        if (!ArrayUtils.contains((Object[])tempary, (Object)obj)) continue;
                        return true;
                    }
                    return false;
                }
            });
            for (String[] sel : selSet) {
                ((CallbackUpdate)reshBacks.get(sel)).doReshConf(props, prop);
            }
            Conf.overProp(prop);
        }

        public void onFileCreate(File file) {
            Properties prop = IOUtil.fileToProperties(file);
            Conf.overProp(prop);
        }
    }
}

