package net.wicp.tams.common.apiext.json;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.templates.TemplateRuntime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.serializerconfig.DoubleSerializerConfig;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.param.Response;

/***
 * JSON对象的扩展
 * 
 * @author andy.zhou
 *
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public abstract class JSONUtil {
	// js里面需要处理的特殊字符集
	public static final String[][] specialChar = new String[][] { { "\\\\", "\\\\\\\\" }, { "\"null\"", "\"\"" } };

	/**
	 * 合并JSon
	 * 
	 * @param res1
	 *            要合并的json对象1
	 * @param res2
	 *            要合并的json对象2
	 * @return JSONObject 合并后的json对象
	 */
	public static JSONObject mergeJSON(JSONObject res1, JSONObject res2) {

		JSONObject addJSON = res1.keySet().size() < res2.keySet().size() ? res1 : res2;
		JSONObject mainJSON = res1.keySet().size() < res2.keySet().size() ? res2 : res1;
		for (Iterator iterator = addJSON.keySet().iterator(); iterator.hasNext();) {
			String key = (String) iterator.next();
			mainJSON.put(key, addJSON.get(key));
		}
		return mainJSON;
	}

	/**
	 * 把JSONObject对象转为list，里面的每个元素为String[2]
	 * 
	 * @param jsonObject
	 *            要合并的json对象1
	 * @return List 转换后列表
	 */
	public static List<String[]> getValues(JSONObject jsonObject) {
		List<String[]> resultList = new ArrayList<String[]>();// 因为是有序的，不能用map
		String key;
		for (Iterator keys = jsonObject.keySet().iterator(); keys.hasNext(); resultList
				.add(new String[] { key, String.valueOf(jsonObject.get(key)) }))
			key = (String) keys.next();
		return resultList;
	}

	/***
	 * 把Map转为json格式的的json数据，全部为String输出 <br>
	 * 结果为：{"itemCode":"returnCheck","itemName":"待退货检查"}
	 * 
	 * @param fromMap
	 *            需要转的map
	 * @param convert
	 *            转换规则，可以为null
	 * @param keys
	 *            需要转的key值，如果不填则为全部 要取的标题，支持别名。 <br>
	 *            如：new String[]{""itemCode,itemCode","itemName_zh,itemName""} <br>
	 *            itemName_zh为是取值的列名,itemName要显示的列名
	 * @return json格式字符串
	 */

	public static String getJsonForMap(Map<String, Object> fromMap, IConvertValue[] convert, String... keys) {
		if (fromMap == null || fromMap.size() == 0) {
			return null;
		}
		keys = ArrayUtils.isNotEmpty(keys) ? keys : (String[]) fromMap.keySet().toArray();
		StringBuffer buff = new StringBuffer("{");
		for (int i = 0; i < keys.length; i++) {
			String key = keys[i];
			String[] keyAry = key.split(",");
			String valCol = StringUtil.trimSpace(keyAry[0]);
			String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
			Object value = StringUtil.isNull(valCol) ? fromMap : fromMap.get(valCol);
			// boolean isall=StringUtil.isNull(valCol)?true:false;//是传整个对象
			String valueTrue = "";
			if (convert != null && convert.length > i && convert[i] != null) {
				IConvertValue convertTrue = convert[i];
				valueTrue = value == null ? "" : convertTrue.getStr(value);
			} else {
				valueTrue = StringUtil.isNull(valCol) ? "" : String.valueOf(value);
			}
			if (i != 0) {
				buff.append(",");
			}
			buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");

		}
		buff.append("}");
		return buff.toString();
	}

	public static String getJsonForMap(Map<String, Object> fromMap, String... keys) {
		return getJsonForMap(fromMap, null, keys);
	}

	/**
	 * 把map转为string
	 * 
	 * @param fromMap
	 *            要转的map
	 * @return 转后的json
	 */
	public static String getJsonForMap(Map fromMap) {
		String str = JSON.toJSONString(fromMap, SerializerFeature.DisableCircularReferenceDetect);
		return str;
	}

	/****
	 * 返回格式 [{"itemCode":"checkNoPass","itemName":"质检不通过"},<br>
	 * { "itemCode":"checkPass","itemName":"质检通过"}]
	 * 
	 * @param fromList
	 *            要取的源数据,支持Map和Object对象
	 * @param converts
	 *            要转换的规则，可以为空，与title要一一对应
	 * @param titles
	 *            要取的标题，支持别名，<br>
	 *            如：new String[]{""itemCode,itemCode","itemName_zh,itemName""} <br>
	 *            itemName_zh为是取值的列名,itemName要显示的列名
	 * 
	 * @return json格式字符串
	 */
	public static String getJsonForList(List<?> fromList, IConvertValue<String>[] converts, String... titles) {
		if (CollectionUtils.isEmpty(fromList) || ArrayUtils.isEmpty(titles)) {
			return "[]";
		}
		StringBuffer buff = new StringBuffer("[");
		for (Object object : fromList) {
			if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
				String singJoson = getJsonForMap((Map) object, converts, titles);
				buff.append(singJoson + ",");
			} else {

				StringBuffer jsonTempStr = new StringBuffer("@{'{");
				for (int i = 0; i < titles.length; i++) {
					String[] titleAry = titles[i].split(",");
					String valCol = StringUtil.trimSpace(titleAry[0]);
					String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
					if (StringUtil.isNull(valCol)) {
						jsonTempStr.append("\"" + showCol + "\":\"\"");
					} else {
						jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
					}
					if (i != titles.length - 1) {
						jsonTempStr.append(",");
					}
				}
				jsonTempStr.append("}'}");
				// 通过规则转换字符
				String tempStr = String.valueOf(TemplateRuntime.eval(jsonTempStr.toString(), object));
				if (ArrayUtils.isNotEmpty(converts)) {
					JSONObject jsObj = JSONObject.parseObject(tempStr);
					for (int i = 0; i < converts.length; i++) {
						IConvertValue convert = converts[i];
						String colName = i < titles.length ? titles[i] : null;
						if (convert != null && StringUtils.isNotBlank(colName)) {
							int index = colName.indexOf(",");
							String key = "";
							// String oriKey = "";
							if (index >= 0) {
								key = colName.substring(index + 1);
								// oriKey = colName.substring(0, index);
							} else {
								key = colName;
								// oriKey = colName;
							}
							String value = index == 0 ? convert.getStr(object) : convert.getStr(jsObj.getString(key));
							jsObj.put(key, value);
						}
					}
					tempStr = jsObj.toString();
				}
				for (int i = 0; i < specialChar.length; i++) {
					String[] tempAry = specialChar[i];
					tempStr = tempStr.replaceAll(tempAry[0], tempAry[1]);
				}
				buff.append(tempStr + ",");
			}
		}
		buff.delete(buff.length() - 1, buff.length());// 去除最后一个“,”
		buff.append("]");
		return buff.toString();
	}

	public static String getJsonForList(List<?> fromList, String... titles) {
		return getJsonForList(fromList, new IConvertValue[] {}, titles);
	}

	/***
	 * 用toString做为text和value
	 * 
	 * @param fromList
	 *            要转换的数据
	 * @return 转换后的json
	 */
	public static String getJsonForListSimple(List<?> fromList) {
		if (CollectionUtils.isEmpty(fromList)) {
			return "[]";
		}
		JSONArray array = new JSONArray();
		for (Object object : fromList) {
			String v = String.valueOf(object);
			array.add(JSONObject.parse(String.format("{\"text\":\"%s\",\"value\":\"%s\"}", v, v)));
		}
		return array.toJSONString();
	}

	/****
	 * 支持Map, Map &lt; String, IConvertValue &gt; key为title 如果是标题有别名方式：aaa,bbb <br>
	 * 则以别名主识别IConvertValue
	 * 
	 * @param fromList
	 *            要取的源数据,支持Map和Object对象
	 * @param convertsMap
	 *            转换器Map
	 * @param titles
	 *            标题
	 * @return json格式字符串
	 */
	public static String getJsonForList(List<?> fromList, Map<String, IConvertValue<String>> convertsMap,
			String... titles) {
		IConvertValue[] convert = null;
		if (convertsMap != null && CollectionUtils.isNotEmpty(convertsMap.keySet())) {
			convert = new IConvertValue[titles.length];
			for (String title : convertsMap.keySet()) {
				int index = -1;
				for (int i = 0; i < titles.length; i++) {
					String eleTitle = titles[i];
					if (StringUtils.isNotBlank(eleTitle)) {
						String[] tempTitleAry = eleTitle.split(",");
						String trueKey = tempTitleAry.length > 1 ? tempTitleAry[1] : tempTitleAry[0];
						if (title.equalsIgnoreCase(trueKey)) {
							index = i;
							break;
						}
					}
				}
				// int index = ArrayUtils.indexOf(titles, title);
				if (index >= 0) {
					convert[index] = convertsMap.get(title);
				}
			}
		}
		return getJsonForList(fromList, convert, titles);
	}

	/****
	 * 别名
	 * 
	 * @param fromList
	 *            要取的源数据,支持Map和Object对象
	 * @param aliasTitles
	 *            标题的别名
	 * @param convertsMap
	 *            要取的源数据,支持Map和Object对象
	 * @return json格式字符串
	 */
	public static String getJsonForListAlias(List<?> fromList, String[] aliasTitles,
			Map<String, IConvertValue<String>> convertsMap) {
		if (CollectionUtils.isEmpty(fromList)) {
			return "[]";
		}
		Object object = fromList.get(0);
		String[] titles = null;
		if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
			Map temp = (Map) object;
			titles = new String[temp.size()];
			int i = 0;
			for (Object keyObj : temp.keySet()) {
				titles[i++] = String.valueOf(keyObj);
			}
		} else {
			List<String> fields = ReflectAssist.findGetField(object.getClass());
			titles = fields.toArray(new String[fields.size()]);
		}
		if (aliasTitles != null && aliasTitles.length > 0) {
			titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
		}
		return getJsonForList(fromList, convertsMap, titles);
	}

	public static String getJsonForListAlias(List<?> fromList) {
		return getJsonForListAlias(fromList, null, null);
	}

	/***
	 * 格式化字符串，可以去除空格 和 换行符等\n
	 * 
	 * @param jsonstr
	 *            原始字符串
	 * @return 格式化后字符串
	 */
	public static String formateJson(String jsonstr) {
		try {
			JSONObject obj = JSONObject.parseObject(jsonstr);
			return obj.toJSONString();
		} catch (Exception e) {
			return StringUtil.trimSpace(jsonstr);
		}
	}

	/***
	 * 打包参数
	 * 
	 * @param params
	 *            要处理的参数
	 * @return 打包后的json对象
	 */
	public static JSONObject packParams(Object... params) {
		JSONObject ret = new JSONObject();
		if (ArrayUtils.isEmpty(params) || params.length < 2) {
			return ret;
		}
		for (int i = 0; i < params.length / 2; i++) {
			Object key = params[2 * i];
			Object value = (2 * i + 1) < params.length ? params[2 * i + 1] : null;
			ret.put(String.valueOf(key), value);
		}
		return ret;
	}

	/***
	 * 打包为数组
	 * 
	 * @param arys
	 *            要打包的数据
	 * @return 打包后的Json数据
	 */
	public static JSONArray packAry(Object... arys) {
		JSONArray ret = new JSONArray();
		if (ArrayUtils.isEmpty(arys)) {
			return ret;
		}
		for (Object ary : arys) {
			ret.add(ary);
		}
		return ret;
	}

	/**
	 * 打包为数组
	 * 
	 * @param arys
	 *            要打包的数据
	 * @return 打包后的Json数据
	 */
	public static JSONArray packAry(String... arys) {
		JSONArray ret = new JSONArray();
		if (ArrayUtils.isEmpty(arys)) {
			return ret;
		}
		for (Object ary : arys) {
			ret.add(ary);
		}
		return ret;
	}

	/***
	 * 结果返回json信息
	 * 
	 * @param result
	 *            要打包的数据
	 * @return 打包后的Json
	 */
	public static JSONObject setResult(Result result) {
		JSONObject retjson = new JSONObject();
		if (result.isSuc()) {
			retjson.put(Response.errorValue, 1000);
			retjson.put(Response.errorDesc, "OK");
			retjson.put(Response.errorCode, "no");
			retjson.put(Response.http, "200");
		} else {
			IExcept iExcept = result.getExcept();
			retjson.put(Response.errorValue, iExcept.getErrorValue());
			retjson.put(Response.errorDesc, iExcept.getErrMsg());
			retjson.put(Response.errorCode, iExcept.getErrorCode());
			retjson.put(Response.http, iExcept.getHttp());
		}
		return retjson;
	}

	/***
	 * double做特殊处理
	 * 
	 * @param object
	 * @return
	 */
	public static String toJSONStringForDouble(Object object) {
		SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
		tamsSerializeConfig.put(Double.class, new DoubleSerializerConfig(new DecimalFormat("0.00")));
		return JSONObject.toJSONString(object, tamsSerializeConfig);
	}

	public static Map<String, Object> jsonToMap(JSONObject json) {
		Map<String, Object> retmap = new HashMap<>();
		if (json == null) {
			return retmap;
		}
		for (String key : json.keySet()) {
			retmap.put(key, json.get(key));
		}
		return retmap;
	}

}
