package net.wicp.tams.common.beans;

import lombok.Builder;
import lombok.Data;

/**
 * 主机
 * 
 * @author 偏锋书生
 *
 */
@Data
@Builder
public class Host implements Comparable<Host> {
	public final static String preVar = "host";

	private String hostIp;
	private int port;
	private String userName;
	private String password;

	// db.tb
	// value为：col逗号分隔

	public Host() {
	}

	public Host(String hostIp, int port, String userName, String password) {
		super();
		this.hostIp = hostIp;
		this.port = port;
		this.userName = userName;
		this.password = password;
	}

	public static Host fromParts(String hostIp, int port) {
		return Host.builder().hostIp(hostIp).port(port).build();
	}

	public Host(String hostIp, int port) {
		this(hostIp, port, null, null);
	}

	@Override
	public boolean equals(Object obj) {
		Host temp = (Host) obj;
		if (this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort()) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return hostIp.hashCode() * 37 + port;
	}

	@Override
	public int compareTo(Host o) {
		String[] ips1 = this.hostIp.split(".");
		String[] ips2 = o.getHostIp().split(".");
		for (int i = 0; i < 4; i++) {
			int si1 = Integer.parseInt(ips1[i]);
			int si2 = Integer.parseInt(ips2[i]);
			if (si1 != si2) {
				return si1 - si2;
			}
		}
		return this.port - o.getPort();
	}

}
