/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import net.wicp.tams.common.apiext.NumberUtil;
import net.wicp.tams.common.beans.MonitorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtil {
    private static final Logger log = LoggerFactory.getLogger(MonitorUtil.class);
    private static final int CPUTIME = 30;
    private static final int PERCENT = 100;
    private static final int FAULTLENGTH = 10;
    private static String linuxVersion = null;

    public MonitorInfo getMonitorInfo(boolean needCpuRatio) throws Exception {
        int kb = 1024;
        long totalMemory = Runtime.getRuntime().totalMemory() / (long)kb;
        long freeMemory = Runtime.getRuntime().freeMemory() / (long)kb;
        long maxMemory = Runtime.getRuntime().maxMemory() / (long)kb;
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        String osName = System.getProperty("os.name");
        long totalMemorySize = osmxb.getTotalPhysicalMemorySize() / (long)kb;
        long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize() / (long)kb;
        long usedMemory = (osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / (long)kb;
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        int totalThread = parentThread.activeCount();
        double cpuRatio = 0.0;
        if (needCpuRatio) {
            cpuRatio = osName.toLowerCase().startsWith("windows") ? this.getCpuRatioForWindows() : MonitorUtil.getCpuRateForLinux();
        }
        MonitorInfo infoBean = new MonitorInfo();
        infoBean.setFreeMemory(freeMemory);
        infoBean.setFreePhysicalMemorySize(freePhysicalMemorySize);
        infoBean.setMaxMemory(maxMemory);
        infoBean.setOsName(osName);
        infoBean.setTotalMemory(totalMemory);
        infoBean.setTotalMemorySize(totalMemorySize);
        infoBean.setTotalThread(totalThread);
        infoBean.setUsedMemory(usedMemory);
        infoBean.setCpuRatio(cpuRatio);
        return infoBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double getCpuRateForLinux() {
        double d;
        StringTokenizer tokenStat;
        BufferedReader brStat;
        InputStreamReader isr;
        InputStream is;
        block5: {
            is = null;
            isr = null;
            brStat = null;
            tokenStat = null;
            Process process = Runtime.getRuntime().exec("top -b -n 1");
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            brStat = new BufferedReader(isr);
            if (!"2.4".equals(linuxVersion)) break block5;
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            brStat.readLine();
            tokenStat = new StringTokenizer(brStat.readLine());
            tokenStat.nextToken();
            tokenStat.nextToken();
            String user = tokenStat.nextToken();
            tokenStat.nextToken();
            String system = tokenStat.nextToken();
            tokenStat.nextToken();
            String nice = tokenStat.nextToken();
            log.info(user + " , " + system + " , " + nice);
            user = user.substring(0, user.indexOf("%"));
            system = system.substring(0, system.indexOf("%"));
            nice = nice.substring(0, nice.indexOf("%"));
            float userUsage = new Float(user).floatValue();
            float systemUsage = new Float(system).floatValue();
            float niceUsage = new Float(nice).floatValue();
            double d2 = (userUsage + systemUsage + niceUsage) / 100.0f;
            MonitorUtil.freeResource(is, isr, brStat);
            return d2;
        }
        try {
            brStat.readLine();
            brStat.readLine();
            tokenStat = new StringTokenizer(brStat.readLine());
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            String cpuUsage = tokenStat.nextToken();
            log.info("CPU idle : " + cpuUsage);
            int index = cpuUsage.indexOf("%");
            Float usage = new Float(index == -1 ? cpuUsage : cpuUsage.substring(0, index));
            BigDecimal temp = NumberUtil.handleScale(usage.floatValue(), 2);
            d = 100.0f - temp.floatValue();
        }
        catch (IOException ioe) {
            double d3;
            try {
                log.error("\u53d6cpu\u4f7f\u7528\u7387\u9519\u8bef", (Throwable)ioe);
                MonitorUtil.freeResource(is, isr, brStat);
                d3 = 1.0;
            }
            catch (Throwable throwable) {
                MonitorUtil.freeResource(is, isr, brStat);
                throw throwable;
            }
            MonitorUtil.freeResource(is, isr, brStat);
            return d3;
        }
        MonitorUtil.freeResource(is, isr, brStat);
        return d;
    }

    private static void freeResource(InputStream is, InputStreamReader isr, BufferedReader br) {
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ioe) {
            log.error("\u91ca\u653e\u8d44\u6e90\u5931\u8d25", (Throwable)ioe);
        }
    }

    private double getCpuRatioForWindows() {
        try {
            String procCmd = System.getenv("windir") + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine,KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(30L);
            long[] c1 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long idletime = c1[0] - c0[0];
                long busytime = c1[1] - c0[1];
                return 100L * busytime / (busytime + idletime);
            }
            return 0.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] readCpu(Process proc) {
        long[] retn = new long[2];
        try {
            proc.getOutputStream().close();
            InputStreamReader ir = new InputStreamReader(proc.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            String line = input.readLine();
            if (line == null || line.length() < 10) {
                long[] lArray = null;
                return lArray;
            }
            int capidx = line.indexOf("Caption");
            int cmdidx = line.indexOf("CommandLine");
            int rocidx = line.indexOf("ReadOperationCount");
            int umtidx = line.indexOf("UserModeTime");
            int kmtidx = line.indexOf("KernelModeTime");
            int wocidx = line.indexOf("WriteOperationCount");
            long idletime = 0L;
            long kneltime = 0L;
            long usertime = 0L;
            while ((line = input.readLine()) != null) {
                if (line.length() < wocidx) continue;
                String caption = MonitorUtil.substring(line, capidx, cmdidx - 1).trim();
                String cmd = MonitorUtil.substring(line, cmdidx, kmtidx - 1).trim();
                if (cmd.indexOf("wmic.exe") >= 0) continue;
                if (caption.equals("System Idle Process") || caption.equals("System")) {
                    idletime += Long.valueOf(MonitorUtil.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    idletime += Long.valueOf(MonitorUtil.substring(line, umtidx, wocidx - 1).trim()).longValue();
                    continue;
                }
                kneltime += Long.valueOf(MonitorUtil.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                usertime += Long.valueOf(MonitorUtil.substring(line, umtidx, wocidx - 1).trim()).longValue();
            }
            retn[0] = idletime;
            retn[1] = kneltime + usertime;
            long[] lArray = retn;
            return lArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                proc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String substring(String src, int start_idx, int end_idx) {
        byte[] b = src.getBytes();
        String tgt = "";
        for (int i = start_idx; i <= end_idx; ++i) {
            tgt = tgt + (char)b[i];
        }
        return tgt;
    }
}

