package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;

/***
 * 编码格式
 * 
 * @author zhoujunhui
 *
 */
public enum Encoding {
	UTF8("UTF-8"), GBK("GBK"), ISO_8859_1("ISO-8859-1");// 二进制流的byte[]需要用ISO_8859_1转码

	private final String encode;

	public String getEncode() {
		return encode;
	}

	private Encoding(String encode) {
		this.encode = encode;
	}

	public static Encoding getByName(String encode) {
		if (StringUtil.isNull(encode)) {// 默认是任意匹配
			return UTF8;
		}
		for (Encoding ele : Encoding.values()) {
			if (encode.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return UTF8;
	}

}
