/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.thread.threadlocal;

import java.util.Map;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerThreadValue;

public class PerthreadManager {
    private static PerthreadManager INSTANCE = new PerthreadManager();
    private final MapHolder holder = new MapHolder();
    private static Object NULL_VALUE = new Object();

    private PerthreadManager() {
    }

    public static final PerthreadManager getInstance() {
        return INSTANCE;
    }

    private Map getPerthreadMap() {
        return (Map)this.holder.get();
    }

    public <T> ObjectCreator<T> createValue(Object key, ObjectCreator<T> delegate) {
        return new DefaultObjectCreator<T>(key, delegate);
    }

    public void cleanValue(Object key) {
        Map map = this.getPerthreadMap();
        map.remove(key);
    }

    public <T> PerThreadValue<T> createValue(Object key) {
        return new DefaultPerThreadValue(key);
    }

    private final class DefaultObjectCreator<T>
    implements ObjectCreator<T> {
        private final Object key;
        private final ObjectCreator<T> delegate;

        DefaultObjectCreator(Object key, ObjectCreator<T> delegate) {
            this.key = key;
            this.delegate = delegate;
        }

        @Override
        public T createObject() {
            Map map = PerthreadManager.this.getPerthreadMap();
            Object storedValue = map.get(this.key);
            if (storedValue != null) {
                return storedValue == NULL_VALUE ? null : (T)storedValue;
            }
            T newValue = this.delegate.createObject();
            map.put(this.key, newValue == null ? NULL_VALUE : newValue);
            return newValue;
        }
    }

    private final class DefaultPerThreadValue<T>
    implements PerThreadValue<T> {
        private final Object key;

        DefaultPerThreadValue(Object key) {
            this.key = key;
        }

        @Override
        public T get() {
            return this.get(null);
        }

        @Override
        public T get(T defaultValue) {
            Map map = PerthreadManager.this.getPerthreadMap();
            Object storedValue = map.get(this.key);
            if (storedValue == null) {
                return defaultValue;
            }
            if (storedValue == NULL_VALUE) {
                return null;
            }
            return (T)storedValue;
        }

        @Override
        public T set(T newValue) {
            PerthreadManager.this.getPerthreadMap().put(this.key, newValue == null ? NULL_VALUE : newValue);
            return newValue;
        }

        @Override
        public boolean exists() {
            return PerthreadManager.this.getPerthreadMap().containsKey(this.key);
        }
    }

    public static class MapHolder
    extends ThreadLocal<Map> {
        @Override
        protected Map initialValue() {
            return CollectionUtil.newMap(new Object[0]);
        }
    }
}

