package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;

/***
 * 操作类型，增删改查
 * 
 * @author zhoujunhui
 *
 */
public enum OptType {
	insert(0), delete(1), update(2), query(3);// 按ptotobuf3的顺序，千万不要改序号

	private final int value;

	public int getValue() {
		return value;
	}

	private OptType(int value) {
		this.value = value;
	}

	public static OptType getByName(String pathpath) {
		if (StringUtil.isNull(pathpath)) {// 默认是classpath根目录
			return null;
		}
		for (OptType ele : OptType.values()) {
			if (pathpath.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
