/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.math.BigDecimal;
import java.util.Date;
import net.wicp.tams.common.constant.DateFormatCase;

public abstract class NumberUtil {
    public static BigDecimal handleScale(BigDecimal input, int scale) {
        return input.setScale(scale, 6);
    }

    public static BigDecimal handleScale(double input, int scale) {
        BigDecimal bigDecimal = new BigDecimal(input);
        return NumberUtil.handleScale(bigDecimal, scale);
    }

    public static BigDecimal handleScale(String input, int scale) {
        BigDecimal bigDecimal = new BigDecimal(input);
        return NumberUtil.handleScale(bigDecimal, scale);
    }

    public static synchronized long proUniqNumByTime() {
        return new Long(DateFormatCase.yyyyMMddHHmmssSSSS.getInstanc().format(new Date()));
    }

    public static BigDecimal addBigDecimal(BigDecimal b1, BigDecimal b2) {
        BigDecimal retObj = null;
        retObj = b1 == null ? b2 : b1.add(b2);
        return NumberUtil.changeBD(retObj);
    }

    public static BigDecimal handNull(BigDecimal ori) {
        return ori == null ? new BigDecimal(0) : ori;
    }

    public static BigDecimal changeBD(Object db) {
        if (db == null) {
            return null;
        }
        if (db instanceof BigDecimal) {
            return NumberUtil.handleScale((BigDecimal)db, 2);
        }
        Double dbd = null;
        if (db instanceof String) {
            dbd = Double.parseDouble(db.toString());
        } else if (db instanceof Double) {
            dbd = (Double)db;
        }
        if (dbd == null) {
            return null;
        }
        return NumberUtil.handleScale(dbd, 2);
    }

    public static double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }
}

