/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import net.wicp.tams.common.I18N.MessageUtils;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.bean.ParamInfoBean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean result;
    private String message;
    private IExcept except;
    private Object[] retObjs;
    private String jsonstrformate = "{\"result\":\"%s\",\"value\":\"%s\",\"code\":\"%s\",\"msg\":\"%s\"}";

    public Result(ProjectException opeExcept) {
        this.result = false;
        if (opeExcept == null) {
            throw new IllegalArgumentException();
        }
        this.except = opeExcept.getExcept();
    }

    public Result(IExcept except) {
        this.result = except == ExceptAll.no;
        this.except = except;
    }

    private Result(boolean result) {
        this.result = result;
    }

    private Result(String message) {
        this.result = false;
        this.except = ExceptAll.project_undefined;
        this.message = message;
    }

    public static Result getSuc() {
        return Result.getSuc(null);
    }

    public static Result getFromJson(String jsonStr) {
        JSONObject jsonobj = JSONObject.parseObject((String)jsonStr);
        boolean result = jsonobj.getBoolean("suc");
        Result retobj = new Result(result);
        retobj.setMessage(jsonobj.getString("message"));
        return retobj;
    }

    public static Result getSuc(String sucInfo) {
        sucInfo = StringUtil.isNull(sucInfo) ? MessageUtils.getInstance().getString("common.hint.success") : sucInfo;
        Result suc = new Result(true);
        suc.setMessage(sucInfo);
        suc.except = ExceptAll.no;
        return suc;
    }

    public static Result getError(String errmsg) {
        return new Result(errmsg);
    }

    public IExcept getExcept() {
        return this.except;
    }

    public boolean isSuc() {
        return this.result;
    }

    public Object retObjs(int index) {
        if (ArrayUtils.isEmpty((Object[])this.retObjs)) {
            return null;
        }
        return this.retObjs[index];
    }

    public Result setRetObjs(Object ... retObjs) {
        this.retObjs = retObjs;
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage(ParamInfoBean errBean) {
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            return this.message;
        }
        return this.except.getErrMsg(errBean);
    }

    public String getMessage() {
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            return this.message;
        }
        return this.except.getErrMsg();
    }

    public JSONObject retJsonObj(ParamInfoBean errBean) {
        String message = this.getMessage(errBean);
        return JSONObject.parseObject((String)String.format(this.jsonstrformate, this.result ? 1 : 0, this.except.getErrorValue(), this.except.getErrorCode(), message));
    }

    public JSONObject retJsonObj() {
        String message = this.getMessage();
        JSONObject retjson = JSONObject.parseObject((String)String.format(this.jsonstrformate, this.result ? 1 : 0, this.except.getErrorValue(), this.except.getErrorCode(), message));
        if (ArrayUtils.isNotEmpty((Object[])this.retObjs)) {
            retjson.put("retObjs", (Object)this.retObjs);
        }
        return retjson;
    }
}

