/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.common.apiext.ClassLoaderPlugin;
import net.wicp.tams.common.apiext.IOUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugin {
    private static final Logger log = LoggerFactory.getLogger(Plugin.class);
    private ClassLoaderPlugin load;
    private final String subClassName;

    public Plugin(String dirpath, String subClassName, ClassLoader parent) {
        Validate.notBlank((CharSequence)dirpath, (String)"\u63d2\u4ef6\u6240\u5728\u7684\u8def\u5f84\u5fc5\u987b\u4f20\u3000", (Object[])new Object[0]);
        this.load = new ClassLoaderPlugin(dirpath, parent);
        this.subClassName = subClassName;
    }

    public ClassLoaderPlugin getLoad() {
        return this.load;
    }

    public Class<?> loadReceive(final String ... excludes) {
        try {
            Set<String> subs = IOUtil.findSubClassByJars(this.subClassName, 5, this.load.getJars(), this.load.getPool());
            if (ArrayUtils.isNotEmpty((Object[])excludes)) {
                CollectionUtils.filter(subs, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return !ArrayUtils.contains((Object[])excludes, (Object)object);
                    }
                });
            }
            if (CollectionUtils.isEmpty(subs) || subs.size() > 1) {
                log.error(" {} \u5b58\u5728\uff12\u4e2a\u5b9e\u73b0\u7c7b,\u8bf7\u68c0\u67e5\u4ee3\u7801", (Object)this.subClassName);
                throw new IllegalArgumentException("recivers error");
            }
            Class<?> calssz = this.load.loadClass(subs.iterator().next());
            return calssz;
        }
        catch (ClassNotFoundException e) {
            log.info("the recicer is error", (Throwable)e);
            throw new RuntimeException("have no recicer");
        }
        catch (Exception e) {
            log.info("load receive is error", (Throwable)e);
            throw new RuntimeException("load receive is error");
        }
    }

    public Object newObject(Map<String, String> params, String ... excludes) {
        try {
            return this.loadReceive(excludes).getConstructor(Map.class).newInstance(params);
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object newObject(JSONObject params, String ... excludes) {
        try {
            return this.loadReceive(excludes).getConstructor(JSONObject.class).newInstance(params);
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object newObject(String ... excludes) {
        try {
            return this.loadReceive(excludes).newInstance();
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

