package net.wicp.tams.common.callback.impl.convertvalue;

import java.util.Locale;
import java.util.ResourceBundle;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.I18N.MessageUtils;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;

/***
 * 异常的国际化,如果没有设置国际化信息就取ExceptAll的desc字段来描述 本对象只适用于commons包中的
 * I18N/MessageBundleUtil 文件中的国际化信息，如有其它国际化信息请把它信就入
 * net.wicp.tams.commons.I18N.MessageUtils.I18Resource即可适用
 * 
 * @author zhoujunhui
 *
 */
@SuppressWarnings("rawtypes")
public class ConvertValueExcept implements IConvertValue<String> {

	private ResourceBundle messages;

	private Class excepclass;

	public ConvertValueExcept(String language) {
		messages = MessageUtils.getInstance(language);
	}

	public ConvertValueExcept(Locale locale) {
		messages = MessageUtils.getInstance(locale);
	}

	public ConvertValueExcept() {
		messages = MessageUtils.getInstance();
	}

	@Override
	public String getStr(String keyObj) {
		try {		
			@SuppressWarnings("unchecked")
			IExcept except = (IExcept)Enum.valueOf(getExcepclass(), keyObj);
			String retstr = messages == null ? "" : messages.getString(except.getErrorCode());
			return StringUtils.isBlank(retstr) ? except.getDesc() : retstr;
		} catch (Exception e) {
			return keyObj;
		}
	}

	public Class getExcepclass() {
		return excepclass == null ? ExceptAll.class : excepclass;
	}

	public void setExcepclass(Class excepclass) {
		this.excepclass = excepclass;
	}

}
