/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.io.File;
import java.net.URL;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;

public enum PathType {
    web("web\u6839\u76ee\u5f55"),
    clp("classpath\u6839\u76ee\u5f55"),
    rel("\u76f8\u5bf9\u4e8eclass\u7684\u8def\u5f84"),
    abs("\u7edd\u5bf9\u8def\u5f84");

    private final String desc;

    private PathType(String desc) {
        this.desc = desc;
    }

    public static String getPath(String inputpath, String splitchar) {
        if (StringUtil.isNull(inputpath)) {
            return "";
        }
        Object[] inputpathary = inputpath.split(splitchar = StringUtil.hasNull(splitchar, ":"));
        if (ArrayUtils.isEmpty((Object[])inputpathary)) {
            return "";
        }
        String PathTypeStr = inputpathary.length > 1 ? inputpathary[0] : "";
        Object inputpathStr = inputpathary.length > 1 ? inputpathary[1] : inputpathary[0];
        PathType pathType = PathType.getByName(PathTypeStr);
        Object retstr = inputpathStr;
        switch (pathType) {
            case web: {
                URL classpathurl = Thread.currentThread().getContextClassLoader().getResource("");
                File file = new File(classpathurl.getPath());
                String webrootstr = file.getParentFile().getParentFile().getPath();
                retstr = IOUtil.mergeFolderAndFilePath(webrootstr, (String)inputpathStr);
                break;
            }
            case clp: {
                URL classpath = Thread.currentThread().getContextClassLoader().getResource("");
                retstr = IOUtil.mergeFolderAndFilePath(classpath.getPath(), (String)inputpathStr);
                break;
            }
            case rel: {
                URL classpathrel = Thread.currentThread().getContextClassLoader().getResource(".");
                retstr = IOUtil.mergeFolderAndFilePath(classpathrel.getPath(), (String)inputpathStr);
                break;
            }
            case abs: {
                retstr = inputpathStr;
                break;
            }
        }
        return retstr;
    }

    public static String getPath(String inputpath) {
        return PathType.getPath(inputpath, ":");
    }

    public static PathType getByName(String pathpath) {
        if (StringUtil.isNull(pathpath)) {
            return clp;
        }
        for (PathType ele : PathType.values()) {
            if (!pathpath.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return clp;
    }

    public String getDesc() {
        return this.desc;
    }
}

