/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.callback.impl.convertvalue;

import java.math.BigDecimal;
import net.wicp.tams.commons.apiext.NumberUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.commons.constant.dic.SizeUnit;

public class ConvertValueSize
implements IConvertValue<String> {
    private final SizeUnit toUnit;
    private final SizeUnit fromUnit;
    private final int scale;

    public ConvertValueSize(SizeUnit fromSizeUnit, SizeUnit toSizeUnit, Integer scale) {
        this.fromUnit = fromSizeUnit;
        this.toUnit = toSizeUnit;
        this.scale = scale == null ? 2 : scale;
    }

    public ConvertValueSize(SizeUnit fromSizeUnit, SizeUnit toSizeUnit) {
        this(fromSizeUnit, toSizeUnit, null);
    }

    @Override
    public String getStr(String keyObj) {
        if (StringUtil.isNull(keyObj)) {
            return "";
        }
        Double temp = this.fromUnit.conv(this.toUnit);
        keyObj = this.fromUnit.filter(keyObj);
        Double db = Double.parseDouble(keyObj);
        Double retdb = db * temp;
        BigDecimal retBig = NumberUtil.handleScale(retdb, this.scale);
        return retBig.doubleValue() + this.toUnit.name();
    }
}

