/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtil {
    private static final Logger log = LoggerFactory.getLogger(TarUtil.class);
    private static final String TAG = TarUtil.class.getName();
    private static final int BUFFER = 1024;
    private static String mCompressSrcParentPath = "";

    public static void decompress(String tarFilePath, String directory) {
        File tarFile = new File(tarFilePath);
        if (!tarFile.exists()) {
            throw new RuntimeException("tar file is not exists.");
        }
        if (!tarFile.isFile()) {
            throw new RuntimeException("compress file is not a file.");
        }
        try {
            FileInputStream ins = new FileInputStream(tarFile);
            TarUtil.decompress(ins, directory);
        }
        catch (FileNotFoundException e) {
            log.error("\u6ca1\u6709\u8fd9\u4e2a\u6587\u4ef6:{}", (Object)tarFilePath);
        }
    }

    public static void decompress(String tarFilePath) {
        tarFilePath = tarFilePath.replace("\\", "/");
        int index = tarFilePath.lastIndexOf("/");
        TarUtil.decompress(tarFilePath, tarFilePath.substring(0, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(InputStream is, String directory) {
        TarArchiveInputStream in = null;
        try {
            in = new TarArchiveInputStream(is, "utf-8");
            TarArchiveEntry entry = in.getNextTarEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    entry = in.getNextTarEntry();
                    continue;
                }
                File curfile = new File(directory, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (OutputStream out = null;){
                    out = new FileOutputStream(curfile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    entry = in.getNextTarEntry();
                }
            }
            in.close();
        }
        catch (Exception e) {
            log.error("compress tar error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
        }
    }

    public static void decompress(byte[] bytes, String directory) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        TarUtil.decompress(bais, directory);
    }

    public static void compress(String srcAbsolutePath, String destAbsolutePath) {
        TarUtil.compress(new File(srcAbsolutePath), destAbsolutePath);
    }

    public static void compress(File srcFile, String destAbsolutePath) {
        File destFile = new File(destAbsolutePath);
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(destFile));
            mCompressSrcParentPath = srcFile.getParent() + File.separator;
            TarUtil.compress(srcFile, taos);
            taos.flush();
            taos.close();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void compress(File file, TarArchiveOutputStream taos) {
        if (file.isDirectory()) {
            TarUtil.compressDir(file, taos);
        } else {
            TarUtil.compressFile(file, taos);
        }
    }

    private static void compressDir(File dir, TarArchiveOutputStream taos) {
        File[] files = dir.listFiles();
        if (files != null) {
            if (files.length == 0) {
                try {
                    taos.putArchiveEntry((ArchiveEntry)TarUtil.createTarArchiveEntry(dir));
                    taos.closeArchiveEntry();
                }
                catch (IOException e) {
                    log.info(TAG, (Object)e.toString());
                }
            } else {
                for (File file : files) {
                    TarUtil.compress(file, taos);
                }
            }
        }
    }

    private static TarArchiveEntry createTarArchiveEntry(File file) {
        return new TarArchiveEntry(file, file.getPath().replace(mCompressSrcParentPath, ""));
    }

    private static void compressFile(File file, TarArchiveOutputStream taos) {
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            taos.putArchiveEntry((ArchiveEntry)TarUtil.createTarArchiveEntry(file));
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                taos.write(data, 0, count);
            }
            bis.close();
            taos.closeArchiveEntry();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    public static void extract(String srcPath, String destPath) {
        File srcFile = new File(srcPath);
        if (srcFile.isFile()) {
            TarUtil.extract(srcFile, destPath);
        }
    }

    public static void extract(File srcFile, String destPath) {
        TarUtil.extract(srcFile, new File(destPath));
    }

    public static void extract(File srcFile, File destFile) {
        try {
            TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new FileInputStream(srcFile));
            TarUtil.extract(destFile, tais);
            tais.close();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void extract(File destFile, TarArchiveInputStream tais) {
        TarArchiveEntry entry = null;
        try {
            while ((entry = tais.getNextTarEntry()) != null) {
                String dirPath = destFile.getPath() + File.separator + entry.getName();
                File dirFile = new File(dirPath);
                TarUtil.createParentDirRecursively(dirFile);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                    continue;
                }
                TarUtil.extractFile(dirFile, tais);
            }
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void extractFile(File destFile, TarArchiveInputStream tais) {
        try {
            int count;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] data = new byte[1024];
            while ((count = tais.read(data, 0, 1024)) != -1) {
                bos.write(data, 0, count);
            }
            bos.close();
        }
        catch (FileNotFoundException e) {
            log.info(TAG, (Object)e.toString());
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void createParentDirRecursively(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            TarUtil.createParentDirRecursively(parentFile);
            parentFile.mkdir();
        }
    }
}

