/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.commons.constant.DateFormatCase;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectAssist {
    private static final Logger log = LoggerFactory.getLogger(ReflectAssist.class);
    private static String[] excludeGet = new String[]{"getClass"};

    public static Object invokeStaticMothed(String className, String methodName, Class[] paramclass, Object ... param) throws Exception {
        Class<?> c = Class.forName(className);
        Method m = c.getMethod(methodName, paramclass);
        Object retobj = m.invoke(c, param);
        return retobj;
    }

    public static Object invokeStaticMothed(String className, String methodName, Object ... param) throws Exception {
        Class[] paramClass = null;
        if (!ArrayUtils.isEmpty((Object[])param)) {
            paramClass = new Class[param.length];
            for (int i = 0; i < param.length; ++i) {
                paramClass[i] = param.getClass();
            }
        }
        return ReflectAssist.invokeStaticMothed(className, methodName, paramClass, param);
    }

    public static Object invokeMothed(Object invokeObj, String methodName, Object ... param) {
        Class<?> c = invokeObj.getClass();
        if (StringUtil.isNull(methodName)) {
            log.error("\u53cd\u5c04\u4e2d\u7f3a\u5c11\u65b9\u6cd5");
            return null;
        }
        Method[] m = c.getMethods();
        Method exeMethod = null;
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] classAry;
            Method tempMethod = m[i];
            if (!methodName.equals(tempMethod.getName()) || (classAry = tempMethod.getParameterTypes()).length != param.length) continue;
            if (param == null && classAry == null || classAry.length == 0 && param.length == 0) {
                exeMethod = tempMethod;
                break;
            }
            boolean isthisMethod = true;
            for (int j = 1; j < classAry.length; ++j) {
                Class<?> classAryEle = classAry[j];
                Object paramEle = param[j];
                if (classAryEle.isArray() && paramEle.getClass().isArray()) {
                    try {
                        Object[] paramArry = param;
                        Object[] classInstArry = (Object[])classAryEle.newInstance();
                        if (!paramArry[0].getClass().isAssignableFrom(classInstArry[0].getClass())) continue;
                        isthisMethod = false;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                if (!paramEle.getClass().isArray() && !classAryEle.isArray()) {
                    if (paramEle.getClass().isAssignableFrom(classAryEle)) continue;
                    isthisMethod = false;
                    break;
                }
                isthisMethod = false;
                break;
            }
            if (!isthisMethod) continue;
            exeMethod = tempMethod;
            break;
        }
        if (exeMethod != null) {
            try {
                return exeMethod.invoke(invokeObj, param);
            }
            catch (Exception e) {
                log.error("\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u51fa\u9519\u3002");
            }
        }
        return null;
    }

    public static boolean isPrimitieClass(Class clz) {
        try {
            return ((Class)clz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> findGetMethod(Class clz) {
        ArrayList<String> methList = new ArrayList<String>();
        Method[] m = clz.getMethods();
        if (m.length == 0) {
            return methList;
        }
        for (int i = 0; i < m.length; ++i) {
            Class<?>[] classAry;
            Method method = m[i];
            String methodName = method.getName();
            if (!methodName.startsWith("get") || ArrayUtils.contains((Object[])excludeGet, (Object)methodName) || (classAry = method.getParameterTypes()).length != 0) continue;
            methList.add(method.getName());
        }
        return methList;
    }

    public static List<String> findGetField(Class clz) {
        ArrayList<String> retList = new ArrayList<String>();
        List<String> methodList = ReflectAssist.findGetMethod(clz);
        for (String methodname : methodList) {
            String ele = methodname.substring(3);
            retList.add(ele.substring(0, 1).toLowerCase() + ele.substring(1));
        }
        return retList;
    }

    public static Map<String, String> convertMapFromBeanForConvert(Object obj, Map<String, IConvertValue> convermap, boolean allowNull) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        if (obj == null) {
            return retmap;
        }
        List<String> fields = ReflectAssist.findGetField(obj.getClass());
        if (CollectionUtils.isNotEmpty(fields)) {
            for (String field : fields) {
                try {
                    String value = null;
                    if (convermap == null || !convermap.containsKey(field)) {
                        value = BeanUtils.getProperty((Object)obj, (String)field);
                    } else {
                        IConvertValue convert = convermap.get(field);
                        if (convert != null) {
                            Object oriDate = PropertyUtils.getProperty((Object)obj, (String)field);
                            value = convert.getStr(oriDate);
                        } else {
                            value = BeanUtils.getProperty((Object)obj, (String)field);
                        }
                    }
                    if (!allowNull && StringUtil.isNull(value) || StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) continue;
                    retmap.put(field, value);
                }
                catch (Exception exception) {}
            }
        }
        return retmap;
    }

    public static <T extends Serializable> Map<String, String> convertMapFromBean(T obj) {
        HashMap<String, String> retmap = new HashMap<String, String>();
        if (obj == null) {
            return retmap;
        }
        List<String> fields = ReflectAssist.findGetField(obj.getClass());
        if (CollectionUtils.isNotEmpty(fields)) {
            for (String field : fields) {
                ReflectAssist.packMap(retmap, null, obj, field);
            }
        }
        return retmap;
    }

    private static void packMap(Map<String, String> map, String oldfield, Object obj, String field) {
        String key = StringUtil.isNull(oldfield) ? field : String.format("%s.%s", oldfield, field);
        Object fieldObj = null;
        try {
            fieldObj = PropertyUtils.getProperty((Object)obj, (String)field);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fieldObj == null) {
            return;
        }
        if (ReflectAssist.isPrimitieClass(fieldObj.getClass()) || fieldObj instanceof String || fieldObj instanceof Enum) {
            String value = String.valueOf(fieldObj);
            if (StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) {
                return;
            }
            map.put(key, value);
        } else if (fieldObj instanceof Date) {
            String datestr = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(fieldObj);
            map.put(key, datestr);
        } else {
            List<String> fields = ReflectAssist.findGetField(fieldObj.getClass());
            if (CollectionUtils.isNotEmpty(fields)) {
                for (String subFields : fields) {
                    ReflectAssist.packMap(map, key, fieldObj, subFields);
                }
            }
        }
    }

    public static <T extends Serializable> T convertMapToBean(Class clazz, Map<String, String> valueMap) {
        if (MapUtils.isEmpty(valueMap)) {
            return null;
        }
        try {
            Serializable t = (Serializable)clazz.newInstance();
            for (String key : valueMap.keySet()) {
                String value = valueMap.get(key);
                StringUtil.packObj(t, key, value);
            }
            return (T)t;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isInterface(Class classz, String szInterface) {
        if (classz.getName().equals(szInterface)) {
            return true;
        }
        Class<?>[] face = classz.getInterfaces();
        int j = face.length;
        for (int i = 0; i < j; ++i) {
            if (face[i].getName().equals(szInterface)) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            for (int x = 0; x < face1.length; ++x) {
                if (face1[x].getName().equals(szInterface)) {
                    return true;
                }
                if (!ReflectAssist.isInterface(face1[x], szInterface)) continue;
                return true;
            }
        }
        if (null != classz.getSuperclass()) {
            return ReflectAssist.isInterface(classz.getSuperclass(), szInterface);
        }
        return false;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return beanInfo.getPropertyDescriptors();
    }

    public static Class getClassRefType(PropertyDescriptor propertyDescriptor) {
        Field[] fields = propertyDescriptor.getClass().getSuperclass().getDeclaredFields();
        if (fields == null || fields.length <= 0) {
            return null;
        }
        for (Field field : fields) {
            if (!"classRef".equals(field.getName())) continue;
            try {
                field.setAccessible(true);
                return (Class)((Reference)field.get(propertyDescriptor)).get();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Class[]> getContextType(Class classz) {
        Field[] fs = classz.getDeclaredFields();
        HashMap<String, Class[]> retMap = new HashMap<String, Class[]>();
        for (Field f : fs) {
            ParameterizedType pt;
            Type fc;
            Class<Object> fieldClazz = f.getType();
            if (fieldClazz.isPrimitive() || fieldClazz.getName().startsWith("java.lang")) continue;
            if (fieldClazz.isAssignableFrom(List.class)) {
                fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                pt = (ParameterizedType)fc;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                retMap.put(f.getName(), new Class[]{genericClazz});
                continue;
            }
            if (fieldClazz.isAssignableFrom(Map.class)) {
                fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                pt = (ParameterizedType)fc;
                Class param0 = (Class)pt.getActualTypeArguments()[0];
                Class param1 = (Class)pt.getActualTypeArguments()[1];
                retMap.put(f.getName(), new Class[]{param0, param1});
                continue;
            }
            if (!fieldClazz.isArray()) continue;
            retMap.put(f.getName(), new Class[]{fieldClazz.getComponentType()});
        }
        return retMap;
    }

    public static Result copyProperties(Object dest, Object orig) {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)orig);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u5c5e\u6027\u51fa\u9519", (Throwable)e);
            return Result.getError(e.getMessage());
        }
    }

    public static void mergeObj(Object to, Object from, String ... removes) {
        ReflectAssist.mergeObj(to, from, false, false, removes);
    }

    public static void mergeObj(Object to, Object from, boolean copyNull, String ... removes) {
        ReflectAssist.mergeObj(to, from, copyNull, true, removes);
    }

    public static void mergeObj(Object to, Object from, boolean copyNull, boolean copyBlank, String ... removes) {
        if (from == null) {
            return;
        }
        List<String> fields = ReflectAssist.findGetField(from.getClass());
        for (String field : fields) {
            if (ArrayUtils.contains((Object[])removes, (Object)field)) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)from, (String)field);
                if (!copyNull && value == null || !copyBlank && StringUtil.isNull(value)) continue;
                BeanUtils.copyProperty((Object)to, (String)field, (Object)value);
            }
            catch (Exception exception) {}
        }
    }
}

