/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import net.wicp.tams.commons.CallbackUpdate;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapObj {
    private static final Logger log = LoggerFactory.getLogger(LdapObj.class);
    private static Object lockobj = new Object();
    private LdapContext ctx = null;
    private static final Control[] connCtls = null;
    private static volatile LdapObj INSTANCE;

    private LdapObj(LdapContext ctx) {
        this.ctx = ctx;
    }

    private LdapObj() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LdapObj getInstance() {
        if (INSTANCE == null) {
            Object object = lockobj;
            synchronized (object) {
                if (INSTANCE == null) {
                    Hashtable<String, String> env = new Hashtable<String, String>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.provider.url", Conf.get("common.apiext.ldap.server.url") + Conf.get("common.apiext.ldap.server.basedn"));
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.security.principal", Conf.get("common.apiext.ldap.server.admin"));
                    env.put("java.naming.security.credentials", Conf.get("common.apiext.ldap.server.password"));
                    env.put("com.sun.jndi.ldap.connect.timeout", Conf.get("common.apiext.ldap.server.timeout"));
                    try {
                        InitialLdapContext ctx = new InitialLdapContext(env, connCtls);
                        INSTANCE = new LdapObj(ctx);
                        log.info("connected.");
                    }
                    catch (NamingException e) {
                        log.error("LDAP\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff1aLDAP\u7f51\u7edc\u5f02\u5e38\u6216\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef", (Throwable)e);
                        throw new RuntimeException("LDAP\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25\uff1aLDAP\u7f51\u7edc\u5f02\u5e38\u6216\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
                    }
                    catch (Exception e) {
                        log.error("connect()\u65b9\u6cd5\u610f\u5916\u5f02\u5e38", (Throwable)e);
                        throw new RuntimeException("LDAP \u672a\u77e5\u5f02\u5e38");
                    }
                }
            }
        }
        return INSTANCE;
    }

    public Attributes getOu(String ou) {
        try {
            Attributes attrs = this.ctx.getAttributes(ou);
            return attrs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Result addOUSingle(String ou) {
        if (StringUtil.isNull(ou) || this.getOu(ou) != null) {
            return Result.getError("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u5df2\u5b58\u5728\u6b64OU");
        }
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("organizationalunit");
        attrs.put(objclass);
        try {
            this.ctx.bind(ou, null, (Attributes)attrs);
            return Result.getSuc();
        }
        catch (NamingException e) {
            log.error("\u6dfb\u52a0OU\u5931\u8d25", (Throwable)e);
            return Result.getError(e.getMessage());
        }
    }

    public String getUserDN(String uid) {
        if (StringUtil.isNull(uid)) {
            return null;
        }
        List<SearchResult> serchlist = this.getSearchResult("", String.format("uid=%s", uid));
        if (CollectionUtils.isEmpty(serchlist)) {
            return null;
        }
        return serchlist.get(0).getName();
    }

    private List<SearchResult> getSearchResult(String searchBase, String filter) {
        SearchResult si = null;
        ArrayList<SearchResult> list = new ArrayList<SearchResult>();
        try {
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> en = this.ctx.search(searchBase, filter, searchCtls);
            while (en != null && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof SearchResult) {
                    si = (SearchResult)obj;
                    if ("".equals(si.getName())) continue;
                    list.add(si);
                    continue;
                }
                log.info("{}\u4e0d\u662fSearchResult\u7c7b\u578b", (Object)obj.toString());
            }
        }
        catch (NamingException ex) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u7ed3\u679c");
        }
        return list;
    }

    public Result addUser(String uid, String ou, Map<String, String> usermap) {
        if (StringUtil.isNull(uid)) {
            return Result.getError("uid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String dn = StringUtil.isNull(ou) ? String.format("uid=%s", uid) : String.format("uid=%s,%s", uid, ou);
        String oldDN = this.getUserDN(uid);
        if (oldDN != null) {
            return Result.getError(String.format("\u5df2\u5b58\u5728\u6b64\u7528\u6237[%s]", oldDN));
        }
        if (this.getOu(ou) == null && !this.addOUSingle(ou).isSuc()) {
            return Result.getError("\u6ca1\u6709\u6b64OU\u4e14\u6dfb\u56de\u6b64OU\u65f6\u5931\u8d25");
        }
        BasicAttributes attrs = new BasicAttributes(true);
        usermap = usermap == null ? new HashMap() : usermap;
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add("person");
        objclass.add("organizationalPerson");
        objclass.add("inetorgperson");
        attrs.put(objclass);
        attrs.put("uid", uid);
        attrs.put("sn", uid);
        attrs.put("cn", uid);
        for (String ele : usermap.keySet()) {
            attrs.put(ele, usermap.get(ele));
        }
        try {
            this.ctx.createSubcontext(dn, (Attributes)attrs);
            return Result.getSuc();
        }
        catch (NamingException e) {
            return Result.getError("\u6dfb\u52a0\u7528\u6237\u65f6\u5f02\u5e38," + e.getMessage());
        }
    }

    static {
        Conf.addCallBack(new CallbackUpdate(){

            @Override
            public void doReshConf(Properties oldProperties, Properties newProperties) {
                if (INSTANCE != null && INSTANCE.ctx != null) {
                    try {
                        INSTANCE.ctx.close();
                    }
                    catch (NamingException e) {
                        log.error("\u5173\u95edLdap\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                    }
                    INSTANCE = null;
                }
            }
        }, "ldap.server.");
    }
}

