/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.InputStreamReader;
import java.io.Reader;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.Match;
import oi.thekraken.grok.api.exception.GrokException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokObj {
    private static final Logger log = LoggerFactory.getLogger(GrokObj.class);
    private static volatile GrokObj INSTANCE;
    private final Grok defaultGrok = new Grok();

    private GrokObj() {
        InputStreamReader reader = new InputStreamReader(IOUtil.fileToInputStream("/patterns/grok-patterns", GrokObj.class));
        try {
            this.defaultGrok.addPatternFromReader((Reader)reader);
        }
        catch (GrokException e) {
            log.error("\u8bfb\u914d\u7f6e\u6587\u4ef6\u9519\u8bef\uff0c\u9ed8\u8ba4\u7684Grok\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GrokObj getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<GrokObj> clazz = GrokObj.class;
        synchronized (GrokObj.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new GrokObj();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Result addPattern(String name, String pattern) {
        if (StringUtil.isNull(name) || StringUtil.isNull(pattern)) {
            return Result.getError("\u7f3a\u5c11\u53c2\u6570");
        }
        try {
            this.defaultGrok.addPattern(name, pattern);
            return Result.getSuc();
        }
        catch (GrokException e) {
            log.error("\u52a0\u89c4\u5219\u5931\u8d25", (Throwable)e);
            return Result.getError("\u52a0\u89c4\u5219\u5931\u8d25");
        }
    }

    public <T> Result addPatternFile(String path, Class<T> classz) {
        try {
            InputStreamReader reader = new InputStreamReader(IOUtil.fileToInputStream(path, classz));
            this.defaultGrok.addPatternFromReader((Reader)reader);
            return Result.getSuc();
        }
        catch (GrokException e) {
            log.error("\u52a0\u89c4\u5219\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.getError("\u52a0\u89c4\u5219\u6587\u4ef6\u5931\u8d25");
        }
    }

    public <T> Result addPatternFile(String path) {
        return this.addPatternFile(path, null);
    }

    public Result addPatternFile(PatternType path) {
        if (path == null) {
            return Result.getError("\u52a0\u89c4\u5219\u6587\u4ef6\u5931\u8d25");
        }
        return this.addPatternFile(String.format("/patterns/%s", path.getPath()), GrokObj.class);
    }

    public Grok getDefaultGrok() {
        return this.defaultGrok;
    }

    public Match match(String pattern, String text) throws GrokException {
        this.defaultGrok.compile(pattern);
        Match gm = this.defaultGrok.match(text);
        gm.captures();
        return gm;
    }

    public static enum PatternType {
        firewalls("firewalls"),
        grokPatterns("grok-patterns"),
        haproxy("haproxy"),
        java("java"),
        junos("junos"),
        linuxSyslog("linux-syslog"),
        mcollective("mcollective"),
        mcollectivePatterns("mcollective-patterns"),
        mongodb("mongodb"),
        nagios("nagios"),
        postgresql("postgresql"),
        redis("redis"),
        ruby("ruby");

        private final String path;

        public String getPath() {
            return this.path;
        }

        private PatternType(String path) {
            this.path = path;
        }
    }
}

