/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.NotFoundException;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderPlugin {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderPlugin.class);
    private URLClassLoader classLoader;
    private ClassPool pool = ClassPool.getDefault();
    private Set<String> jars = new HashSet<String>();

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<String> getJars() {
        return this.jars;
    }

    public ClassPool getPool() {
        return this.pool;
    }

    public ClassLoaderPlugin(String jarfileDir, ClassLoader parent) {
        this(new File(jarfileDir), parent);
    }

    public ClassLoaderPlugin(File jarfileDir) {
        this(jarfileDir, null);
    }

    public ClassLoaderPlugin(File jarfileDir, ClassLoader parent) {
        this.classLoader = this.createClassLoader(jarfileDir, parent);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public void addToClassLoader(String baseDir, FileFilter filter) {
        File base = new File(baseDir);
        if (base != null && base.exists() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (files == null || files.length == 0) {
                log.warn("No files added to classloader from lib: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
            } else {
                this.classLoader = this.replaceClassLoader(this.classLoader, base, filter);
            }
        } else {
            log.warn("Can't find (or read) directory to add to classloader: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
        }
    }

    public void addToClassLoader(String baseDir) {
        this.addToClassLoader(baseDir, (FileFilter)new SuffixFileFilter(".jar"));
    }

    private URLClassLoader createClassLoader(File libDir, ClassLoader parent) {
        if (null == parent) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        return this.replaceClassLoader(URLClassLoader.newInstance(new URL[0], parent), libDir, (FileFilter)new SuffixFileFilter(".jar"));
    }

    private URLClassLoader replaceClassLoader(URLClassLoader oldLoader, File base, FileFilter filter) {
        if (null != base && base.canRead() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (null == files || 0 == files.length) {
                log.error("replaceClassLoader base dir:{} is empty", (Object)base.getAbsolutePath());
                return oldLoader;
            }
            log.error("replaceClassLoader base dir: {} ,size: {}", (Object)base.getAbsolutePath(), (Object)files.length);
            URL[] oldElements = oldLoader.getURLs();
            URL[] elements = new URL[oldElements.length + files.length];
            System.arraycopy(oldElements, 0, elements, 0, oldElements.length);
            for (int j = 0; j < files.length; ++j) {
                try {
                    URL element;
                    elements[oldElements.length + j] = element = files[j].toURI().normalize().toURL();
                    this.jars.add(files[j].getPath());
                    log.info("Adding '{}' to classloader", (Object)element.toString());
                    this.pool.appendClassPath(files[j].getPath());
                    log.info("Adding '{}' to pool", (Object)element.toString());
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error("load jar file error", (Throwable)e);
                    throw new RuntimeException("load jar file error ");
                }
                catch (NotFoundException e) {
                    log.error("add jar to pool error", (Throwable)e);
                    throw new RuntimeException("pool addpath error ");
                }
            }
            ClassLoader oldParent = oldLoader.getParent();
            try {
                oldLoader.close();
            }
            catch (IOException e) {
                log.error("close classload error ", (Throwable)e);
            }
            return URLClassLoader.newInstance(elements, oldParent);
        }
        return oldLoader;
    }
}

