/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.wicp.tams.commons.io.UnsignedLong;
import org.apache.commons.lang3.ArrayUtils;

public abstract class ByteUtil {
    private static final int[] ones = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    public static byte[] toBigEndian(byte[] value) {
        int length = value.length >> 2;
        for (int i = 0; i <= length; ++i) {
            int j = value.length - 1 - i;
            byte t = value[i];
            value[i] = value[j];
            value[j] = t;
        }
        return value;
    }

    public static int toUnsigned(byte b) {
        return b & 0xFF;
    }

    public static int toUnsigned(short s) {
        return s & 0xFFFF;
    }

    public static long toUnsigned(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public static long readLong(byte[] bytes, boolean littleEndian) {
        long r = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            long v = ByteUtil.toUnsigned(bytes[i]);
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public static long readLongL(byte[] bytes) {
        return ByteUtil.readLong(bytes, true);
    }

    public static long readLongL(byte[] bytes, int offset, int length) {
        byte[] temp = Arrays.copyOfRange(bytes, offset, offset + length);
        return ByteUtil.readLongL(temp);
    }

    public static long readLongB(byte[] bytes) {
        return ByteUtil.readLong(bytes, false);
    }

    public long readLongSigned(byte[] bytes) {
        long r = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            long v = ByteUtil.toUnsigned(bytes[i]);
            r |= v << (i << 3);
            if (i != bytes.length - 1 || (v & 0x80L) != 128L) continue;
            for (int j = bytes.length; j < 8; ++j) {
                r |= (long)(255 << (j << 3));
            }
        }
        return r;
    }

    public static int byteshas1(byte[] bytes) {
        int ret = 0;
        for (int i = 0; i < bytes.length; ++i) {
            ret += ones[bytes[i] & 0xFF];
        }
        return ret;
    }

    public static int byteshas1(int a) {
        return ones[a & 0xFF] + ones[a >> 8 & 0xFF] + ones[a >> 16 & 0xFF] + ones[a >> 24 & 0xFF];
    }

    public static int byteshas0(byte[] bytes) {
        int has1 = ByteUtil.byteshas1(bytes);
        return bytes.length * 8 - has1;
    }

    public static int readInt(byte[] bytes, boolean littleEndian) {
        int r = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = ByteUtil.toUnsigned(bytes[i]);
            if (littleEndian) {
                r |= v << (i << 3);
                continue;
            }
            r = r << 8 | v;
        }
        return r;
    }

    public static int readIntL(byte[] bytes) {
        return ByteUtil.readInt(bytes, true);
    }

    public static int readIntL(byte[] bytes, int offset, int length) {
        byte[] temp = Arrays.copyOfRange(bytes, offset, offset + length);
        return ByteUtil.readIntL(temp);
    }

    public static int readIntB(byte[] bytes) {
        return ByteUtil.readInt(bytes, false);
    }

    public static int readIntSigned(byte[] bytes) {
        int r = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = ByteUtil.toUnsigned(bytes[i]);
            r |= v << (i << 3);
            if (i != bytes.length - 1 || (v & 0x80) != 128) continue;
            for (int j = bytes.length; j < 4; ++j) {
                r |= 255 << (j << 3);
            }
        }
        return r;
    }

    public static String readString(byte[] bytes) {
        try {
            String retstr = new String(ByteUtil.trunc00(bytes), "UTF-8");
            return retstr;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] trunc00(byte[] bytes) {
        int begindex = -1;
        int endindex = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0 && begindex < 0) {
                begindex = i;
                continue;
            }
            if (bytes[i] != 0 || begindex < 0) continue;
            endindex = i;
            break;
        }
        if (begindex < 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (endindex < 0) {
            return bytes;
        }
        return ArrayUtils.subarray((byte[])bytes, (int)begindex, (int)endindex);
    }

    public static String readString(byte[] bytes, int offset, int length) {
        byte[] temp = Arrays.copyOfRange(bytes, offset, offset + length);
        return ByteUtil.readString(ByteUtil.trunc00(temp));
    }

    public static byte[] toByteArray(byte num) {
        return new byte[]{num};
    }

    public static byte[] toByteArray(short num) {
        byte[] r = new byte[2];
        for (int i = 0; i < 2; ++i) {
            r[i] = (byte)(num >>> 8 - i * 8);
        }
        return r;
    }

    public static byte[] toByteArray(int num) {
        byte[] r = new byte[4];
        for (int i = 0; i < 4; ++i) {
            r[i] = (byte)(num >>> 24 - i * 8);
        }
        return r;
    }

    public static byte[] toByteArray(long num) {
        byte[] r = new byte[8];
        for (int i = 0; i < 8; ++i) {
            r[i] = (byte)(num >>> 56 - i * 8);
        }
        return r;
    }

    public static byte[][] splitBytes(byte[] data, int maxLength) {
        if (data.length <= maxLength) {
            return new byte[][]{data};
        }
        int length = data.length / maxLength + 1;
        byte[][] retary = new byte[length][maxLength];
        for (int l = 0; l < data.length; ++l) {
            int i = l / maxLength;
            int j = l % maxLength;
            retary[i][j] = data[l];
        }
        return retary;
    }

    public static byte[] or(byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("array lenth does NOT match, " + data1.length + " vs " + data2.length);
        }
        byte[] r = new byte[data1.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)(data1[i] | data2[i]);
        }
        return r;
    }

    public static byte[] and(byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("array lenth does NOT match, " + data1.length + " vs " + data2.length);
        }
        byte[] r = new byte[data1.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)(data1[i] & data2[i]);
        }
        return r;
    }

    public static byte[] xor(byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            throw new IllegalArgumentException("array lenth does NOT match, " + data1.length + " vs " + data2.length);
        }
        byte[] r = new byte[data1.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)(data1[i] ^ data2[i]);
        }
        return r;
    }

    public static boolean equals(byte[] data1, byte[] data2) {
        return Arrays.equals(data1, data2);
    }

    public static byte[] concat(byte[] data1, byte[] data2) {
        byte[] r = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, r, 0, data1.length);
        System.arraycopy(data2, 0, r, data1.length, data2.length);
        return r;
    }

    public static class AssitRead {
        private final byte[] data;
        private int curpos = 0;

        public int getCurpos() {
            return this.curpos;
        }

        public AssitRead(byte[] data) {
            this.data = data;
        }

        public byte[] readBytes(int length) {
            byte[] ret = ArrayUtils.subarray((byte[])this.data, (int)this.curpos, (int)(this.curpos + length));
            this.curpos += length;
            return ret;
        }

        public byte readByte() {
            return this.readBytes(1)[0];
        }

        public boolean hasMore() {
            return this.curpos < this.data.length;
        }

        public String readStringEndNull() throws IOException {
            byte v;
            byte[] allbyte = new byte[128];
            int i = 0;
            while ((v = this.readByte()) != 0) {
                allbyte[i++] = v;
            }
            return ByteUtil.readString(allbyte);
        }

        public UnsignedLong readUnsignedLong() {
            int v = ByteUtil.toUnsigned(this.readByte());
            if (v < 251) {
                return UnsignedLong.valueOf(v);
            }
            if (v == 251) {
                return null;
            }
            if (v == 252) {
                return UnsignedLong.valueOf(ByteUtil.readLongL(this.readBytes(2)));
            }
            if (v == 253) {
                return UnsignedLong.valueOf(ByteUtil.readLongL(this.readBytes(3)));
            }
            if (v == 254) {
                return UnsignedLong.valueOf(ByteUtil.readLongL(this.readBytes(8)));
            }
            throw new RuntimeException("assertion failed, should NOT reach here");
        }

        public String readStringUnsignedLong() {
            UnsignedLong length = this.readUnsignedLong();
            String retstr = ByteUtil.readString(this.readBytes(length.intValue()));
            return retstr;
        }

        public byte[] readRest() {
            byte[] ret = ArrayUtils.subarray((byte[])this.data, (int)this.curpos, (int)this.data.length);
            return ret;
        }

        public void skip(int length) {
            this.curpos += length;
        }
    }

    public static class AssitWrite {
        private final byte[] buff;
        private int curPos = 0;

        public AssitWrite(int size) {
            this.buff = new byte[size];
        }

        public void writeByte(byte[] data, int leng, boolean littleEndian) {
            if (littleEndian) {
                ArrayUtils.reverse((byte[])data);
            }
            int copylen = data.length > leng ? leng : data.length;
            for (int i = 0; i < copylen; ++i) {
                this.buff[this.curPos + i] = data[i];
            }
            this.curPos += leng;
        }

        public void write(byte[] data) {
            this.writeByte(data, data.length, false);
        }

        public void write(int data, int leng) {
            this.writeByte(ByteUtil.toByteArray(data), leng, true);
        }

        public void write(long data, int leng) {
            this.writeByte(ByteUtil.toByteArray(data), leng, true);
        }

        public void write(String data, int leng) {
            try {
                this.writeByte(data.getBytes("UTF-8"), leng, false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public void write(String data) {
            this.write(data, data.length());
        }

        public void writeEndNull(byte[] data) {
            this.write(data);
            this.write(0, 1);
        }

        public byte[] get() {
            return Arrays.copyOf(this.buff, this.curPos);
        }
    }
}

