/**   
 * @Title: ExceptAll.java
 * @Package rjzjh.tech.common.Exception
 * @Description: TODO(用一句话描述该文件做什么)
 * @author 周俊辉  
 * @date 2010-10-29 下午01:26:42
 * @version V1.0   
 */
package net.wicp.tams.commons.exception;

import org.mvel2.templates.TemplateRuntime;

import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.callback.impl.convertvalue.ConvertValueExcept;

/***
 * 自定义异常编码与其解释（测试用）
 * 
 * @author andy.zhou
 *
 */
public enum ExceptAll implements IExcept {
	// 系统通用型错误(包括Java相关错误) 在 1000-1999
	no("没有异常", 1000, 200),

	project_undefined("未定义异常", 1001),

	project_user("自定义异常", 1002),

	Project_default("系统错误", 1003, 500),

	project_noservice("错误的服务，没有定义的服务", 1004, 503),

	project_clienterror("客户端连接错误", 1005, 400),

	project_streamclose("流关闭错误", 1006),

	project_nonull("不允许为空值", 1007),

	project_overflow("数据值超出许可范围", 1008),

	project_overarry("数据元素越界", 1009),

	project_formatnofit("格式不匹配", 1010),

	project_datenofitformate("时间格式不对", 1011),

	project_serviceerror("服务错误", 1012, 500),

	project_runshell("运行shell/cmd命令失败", 1013, 500),

	project_other("其它错误", 1999, 501),

	// 参数错误 2000-2099
	param_error("参数错误", 2000, 400),

	Param_dynaerror("动态参数错误", 2001, new IDynaMsg() {
		@Override
		public String packMsg(String msg, Object ctx) {
			String retstr = (String) TemplateRuntime.eval(msg, ctx);
			return retstr;
		}
	}),

	Param_typenofit("参数类型不匹配", 2002),

	Param_lengthover("参数长度越界", 2003),

	param_notfit("请求参数不合法", 2004, 400),

	// 联接错误 2100－2129
	conn_nocontrol("输入参数没有控制信息", 2100, 400),

	conn_nochannel("没有渠道信息", 2101, 400),

	// 授权错误 2130－2159
	auth_no_rightful("权鉴不通过", 2130, 401),

	auth_no_login("没有登陆", 2131, 401),

	// 2160-2199
	mybatis_notable("没有表", 2160, 400);

	// 其它 2160~~~

	private String desc;
	private int value;
	private int httpCode;
	private int httpCodeSub;

	private IDynaMsg dynaMsg = null;

	private ExceptAll(String desc, int value) {
		this.desc = desc;
		this.value = value;
	}

	private ExceptAll(String desc, int value, int httpCode) {
		this.desc = desc;
		this.value = value;
		this.httpCode = httpCode;
	}

	private ExceptAll(String desc, int value, int httpCode, int httpCodeSub) {
		this.desc = desc;
		this.value = value;
		this.httpCode = httpCode;
		this.httpCodeSub = httpCodeSub;
	}

	private ExceptAll(String desc, int value, IDynaMsg dynaMsg) {
		this.desc = desc;
		this.value = value;
		this.dynaMsg = dynaMsg;
	}

	@Override
	public String getDesc() {
		return this.desc;
	}

	@Override
	public int getErrorValue() {
		return this.value;
	}

	@Override
	public String getErrorCode() {
		return this.name();
	}

	@Override
	public String getErrMsg(Object errBean) {
		ConvertValueExcept cv = new ConvertValueExcept(Conf.getCurLocale());
		return packmsg(cv.getStr(this), errBean);
	}

	@Override
	public String getErrMsg() {
		return getErrMsg(null);
	}

	public String getHttp() {
		if (httpCode == 0 && httpCodeSub == 0) {
			return "200";// 未定义http编码
		}
		if (httpCodeSub == 0) {
			return Integer.toString(httpCode);
		}
		return String.format("%s.%s", httpCode, httpCodeSub);
	}

	private String packmsg(String msg, Object ctx) {
		if (dynaMsg != null && ctx != null) {
			msg = dynaMsg.packMsg(msg, ctx);
		}
		return msg;
	}

	public int getHttpCode() {
		return httpCode;
	}

	public void setHttpCode(int httpCode) {
		this.httpCode = httpCode;
	}

	public int getHttpCodeSub() {
		return httpCodeSub;
	}

	public void setHttpCodeSub(int httpCodeSub) {
		this.httpCodeSub = httpCodeSub;
	}

}
