/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.beans;

public class Host
implements Comparable<Host> {
    public static final String preVar = "host";
    private String hostName;
    private String hostIp;
    private int port;

    public Host() {
    }

    public Host(String hostName, String hostIp, int port) {
        this.hostName = hostName;
        this.hostIp = hostIp;
        this.port = port;
    }

    public boolean equals(Object obj) {
        Host temp = (Host)obj;
        return this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort();
    }

    public int hashCode() {
        return this.hostIp.hashCode() * 37 + this.port;
    }

    @Override
    public int compareTo(Host o) {
        String[] ips1 = this.hostIp.split(".");
        String[] ips2 = o.getHostIp().split(".");
        for (int i = 0; i < 4; ++i) {
            int si2;
            int si1 = Integer.parseInt(ips1[i]);
            if (si1 == (si2 = Integer.parseInt(ips2[i]))) continue;
            return si1 - si2;
        }
        return this.port - o.getPort();
    }

    public static HostBuilder builder() {
        return new HostBuilder();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return "Host(hostName=" + this.getHostName() + ", hostIp=" + this.getHostIp() + ", port=" + this.getPort() + ")";
    }

    public static class HostBuilder {
        private String hostName;
        private String hostIp;
        private int port;

        HostBuilder() {
        }

        public HostBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public HostBuilder hostIp(String hostIp) {
            this.hostIp = hostIp;
            return this;
        }

        public HostBuilder port(int port) {
            this.port = port;
            return this;
        }

        public Host build() {
            return new Host(this.hostName, this.hostIp, this.port);
        }

        public String toString() {
            return "Host.HostBuilder(hostName=" + this.hostName + ", hostIp=" + this.hostIp + ", port=" + this.port + ")";
        }
    }
}

