package net.wicp.tams.commons.constant;

import net.wicp.tams.commons.apiext.StringUtil;

/***
 * 操作类型，增删改查
 * 
 * @author zhoujunhui
 *
 */
public enum OptType {
	insert(0), delete(2), update(1), query(3);
	
	private final int value;
	
	public int getValue() {
		return value;
	}

	private OptType(int value){
		this.value=value;
	}

	public static OptType getByName(String pathpath) {
		if (StringUtil.isNull(pathpath)) {// 默认是classpath根目录
			return null;
		}
		for (OptType ele : OptType.values()) {
			if (pathpath.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
