/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcUtil {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);

    public static Connection getConnection(String driverName, String dburl, String userName, String pwd) {
        Connection conn = null;
        try {
            Class.forName(driverName);
            conn = StringUtil.isNull(userName) || StringUtil.isNull(pwd) ? DriverManager.getConnection(dburl) : DriverManager.getConnection(dburl, userName, pwd);
            return conn;
        }
        catch (Exception e) {
            log.error(String.format("\u8fde\u63a5\u9519\u8bef\uff0c\u5730\u5740[%s]", dburl), (Throwable)e);
            return null;
        }
    }

    public static Connection getConnection(String driverName, String dburl) {
        return JdbcUtil.getConnection(driverName, dburl, null, null);
    }

    public static ResultSet querySql(Connection conn, String sql) {
        Statement stmt = null;
        try {
            if (conn == null || conn.isClosed()) {
                return null;
            }
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            return rs;
        }
        catch (SQLException e) {
            log.error(String.format("\u67e5\u8be2sql\u51fa\u9519\uff0csql:[%s]", sql), (Throwable)e);
            return null;
        }
    }

    public static void setPreParam(PreparedStatement stmt, Object ... queryParams) throws SQLException {
        if (stmt == null) {
            return;
        }
        int needparamscount = stmt.getParameterMetaData().getParameterCount();
        if (needparamscount == 0 && ArrayUtils.isEmpty((Object[])queryParams)) {
            return;
        }
        if (needparamscount != queryParams.length) {
            throw new SQLException(String.format("\u53c2\u6570\u7684\u4e2a\u6570\u4e0d\u5339\u914d\uff0c\u9700\u8981[%s]\u4e2a\u53c2\u6570\uff0c\u4f46\u4f20\u8fdb\u6765[%s]\u4e2a\u53c2\u6570", needparamscount, queryParams.length));
        }
        for (int i = 0; i < queryParams.length; ++i) {
            Object queryParam = queryParams[i];
            String valueStr = String.valueOf(queryParam);
            if (queryParam instanceof String) {
                stmt.setString(i + 1, valueStr);
                continue;
            }
            if (queryParam instanceof Integer) {
                stmt.setInt(i + 1, Integer.parseInt(valueStr));
                continue;
            }
            if (queryParam instanceof Date) {
                stmt.setDate(i + 1, new java.sql.Date(((Date)queryParam).getTime()));
                continue;
            }
            if (queryParam instanceof Long) {
                stmt.setLong(i + 1, Long.parseLong(valueStr));
                continue;
            }
            if (queryParam instanceof Boolean) {
                stmt.setBoolean(i + 1, Boolean.parseBoolean(valueStr));
                continue;
            }
            throw new SQLException(String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b,\u53c2\u6570\u503c[%s]", valueStr));
        }
    }
}

