/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.CollectionUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.BasePath;
import net.wicp.tams.commons.constant.Encoding;
import net.wicp.tams.commons.thread.ThreadPool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOUtil {
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);

    public static String slurp(InputStream in, Encoding oriEncoding) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n, oriEncoding.getEncode()));
        }
        return out.toString();
    }

    public static String slurp(InputStream in) throws IOException {
        return IOUtil.slurp(in, Encoding.UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(String filePath, Class classz) {
        Properties returnPro = new Properties();
        InputStream inputFile = null;
        try {
            inputFile = IOUtil.fileToInputStream(filePath, classz);
            returnPro.load(inputFile);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6{}", (Object)filePath);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6{}\u9519\u8bef", (Object)filePath);
        }
        finally {
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u51fa\u9519");
                }
            }
        }
        return returnPro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(File filePath) {
        Properties returnPro = new Properties();
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(filePath);
            returnPro.load(inputFile);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6{}", (Object)filePath);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6{}\u9519\u8bef", (Object)filePath);
        }
        finally {
            if (inputFile != null) {
                try {
                    ((InputStream)inputFile).close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u51fa\u9519");
                }
            }
        }
        return returnPro;
    }

    public static InputStream fileToInputStream(String filePath, Class classz) {
        InputStream inputFile = null;
        if (StringUtil.isNull(filePath)) {
            return null;
        }
        filePath = filePath.replace("\\", "/");
        log.info("--------filePath:{}-------------", (Object)filePath);
        if (classz != null) {
            inputFile = classz.getResourceAsStream(filePath);
            if (inputFile == null && !filePath.startsWith("/") && !filePath.startsWith("\\")) {
                inputFile = classz.getResourceAsStream("/" + filePath);
            }
        } else {
            inputFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        }
        return inputFile;
    }

    public static Properties fileToProperties(String filePath) {
        return IOUtil.fileToProperties(filePath, null);
    }

    public static String mergeFolderAndFilePath(String folderPath, String fileName) {
        if (StringUtils.isBlank((CharSequence)folderPath)) {
            return fileName;
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return folderPath;
        }
        folderPath = folderPath.replace("\\", "/");
        fileName = fileName.replace("\\", "/");
        if (folderPath.endsWith("/")) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        return String.format("%s/%s", folderPath, fileName);
    }

    public static String getDirForFilePath(Class classStr, String filePath) {
        URL url = classStr.getResource(filePath);
        int lastIndex = url.getPath().lastIndexOf("/");
        if (lastIndex > 0) {
            return url.getPath().substring(0, lastIndex);
        }
        return null;
    }

    public static String getDirForCommonUtilFilePath(String filePath) {
        return IOUtil.getDirForFilePath(IOUtil.class, filePath);
    }

    public static long copyInToOut(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[1024];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void replaceFile(String oriPath, String destPath, Encoding oriEncoding, Encoding destEncoding, String ... replaceRule) throws IOException {
        String strs = FileUtils.readFileToString((File)new File(oriPath), (String)oriEncoding.getEncode());
        IOUtil.replaceFileByStr(strs, destPath, oriEncoding, destEncoding, replaceRule);
    }

    public static void replaceFileByStr(String oriContext, String destPath, Encoding oriEncoding, Encoding destEncoding, String ... replaceRule) throws IOException {
        if (ArrayUtils.isNotEmpty((Object[])replaceRule) && replaceRule.length >= 2) {
            for (int i = 0; i < replaceRule.length / 2; ++i) {
                oriContext = oriContext.replaceAll(replaceRule[2 * i], replaceRule[2 * i + 1]);
            }
        }
        File destfile = new File(destPath);
        FileUtils.writeStringToFile((File)destfile, (String)oriContext, (String)destEncoding.getEncode());
    }

    public static void replaceFileByStr(String oriContext, String destPath, String ... replaceRule) throws IOException {
        IOUtil.replaceFileByStr(oriContext, destPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
    }

    public static void replaceFileByStr(String oriContext, BasePath basePath, String relaPath, String ... replaceRule) throws IOException {
        String path = IOUtil.mergeFolderAndFilePath(basePath.getPath(), relaPath);
        IOUtil.replaceFileByStr(oriContext, path, replaceRule);
    }

    public static void replaceFile(String oriPath, String destPath, String ... replaceRule) throws IOException {
        IOUtil.replaceFile(oriPath, destPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
    }

    public static void replaceDir(String oriPath, String destPath, String ... replaceRule) throws IOException {
        Collection files = FileUtils.listFiles((File)new File(oriPath), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : files) {
            String filepath = file.getPath().replace("\\", "/");
            filepath = filepath.charAt(0) == '/' ? filepath : "/" + filepath;
            String newPath = filepath.replace(oriPath, destPath);
            if (!file.isDirectory()) {
                IOUtil.replaceFile(file.getPath(), newPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
                continue;
            }
            FileUtils.copyFile((File)file, (File)new File(newPath));
        }
    }

    public static Map<String, InputStream> getFilesFromJar(String jarUrlStr, String dirPath, String ... suffix) throws Exception {
        int lastIndex;
        JarFile jarFile = IOUtil.jarRead(jarUrlStr);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        HashMap<String, InputStream> retobj = new HashMap<String, InputStream>();
        if (jarEntrys == null || !jarEntrys.hasMoreElements()) {
            return retobj;
        }
        int firstIndex = jarUrlStr.indexOf(".jar!/");
        int n = lastIndex = jarUrlStr.endsWith(".jar") ? jarUrlStr.lastIndexOf(".jar") : jarUrlStr.lastIndexOf(".jar!/");
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = entry.getName();
            System.out.println(name);
            boolean need = false;
            if (firstIndex != lastIndex && name.endsWith(".jar")) {
                need = true;
            } else if ((".".equals(dirPath) && name.indexOf("/") == -1 || name.startsWith(dirPath)) && !entry.isDirectory()) {
                if (ArrayUtils.isNotEmpty((Object[])suffix)) {
                    int lastindex = name.lastIndexOf(".");
                    if (lastindex > 0 && ArrayUtils.contains((Object[])suffix, (Object)name.substring(lastindex + 1))) {
                        need = true;
                    }
                } else {
                    need = true;
                }
            }
            if (!need) continue;
            InputStream is = jarFile.getInputStream(entry);
            retobj.put(name, is);
        }
        return retobj;
    }

    public static JarFile jarRead(String jarUrlStr) throws MalformedURLException, IOException {
        jarUrlStr = jarUrlStr.startsWith("jar:") ? jarUrlStr : String.format("jar:%s", jarUrlStr);
        String jarPath = jarUrlStr.indexOf("!/") > 0 ? jarUrlStr.substring(0, jarUrlStr.indexOf("!/") + 2) : jarUrlStr + "!/";
        URL jarURL = new URL(jarPath);
        JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
        JarFile jarFile = jarCon.getJarFile();
        return jarFile;
    }

    public static List<String> getClassNameFromJar(String jarUrlStr, String filtDirPath) throws Exception {
        JarFile jarFile = IOUtil.jarRead(jarUrlStr);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        ArrayList<String> retlist = new ArrayList<String>();
        if (jarEntrys == null || !jarEntrys.hasMoreElements()) {
            return retlist;
        }
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class") || entry.isDirectory() || !StringUtil.isNull(filtDirPath) && !name.startsWith(filtDirPath)) continue;
            String addstr = name.substring(0, name.length() - 6);
            retlist.add(addstr.replace("/", "."));
        }
        return retlist;
    }

    public static List<String> getClassNameFromDir(String classDir, String packageName) {
        String classDirTrue = classDir.replace("\\", "/");
        if (StringUtil.isNotNull(packageName)) {
            classDirTrue = IOUtil.mergeFolderAndFilePath(classDirTrue, packageName.replace(".", "/"));
        }
        Collection files = FileUtils.listFiles((File)new File(classDirTrue), (String[])new String[]{"class"}, (boolean)true);
        ArrayList<String> retlist = new ArrayList<String>();
        for (File file : files) {
            String filepathTemp = file.getPath().replace("\\", "/");
            if ((filepathTemp = filepathTemp.substring(0, filepathTemp.length() - 6).replace(classDir.replace("\\", "/"), "")).startsWith("/")) {
                filepathTemp = filepathTemp.substring(1);
            }
            filepathTemp = filepathTemp.replace("/", ".");
            retlist.add(filepathTemp);
        }
        return retlist;
    }

    public static List<String> getSubTypeFromJar(String jarUrlStr, String dirPath, String parentClassName, ClassPool pool) throws Exception {
        List<String> allClassName = IOUtil.getClassNameFromJar(jarUrlStr, dirPath);
        IOUtil.subClassFilter(allClassName, parentClassName, pool);
        return allClassName;
    }

    public static List<String> getSubTypeFromDir(String classDir, String packageName, String parentClassName, ClassPool pool) throws Exception {
        List<String> allClassName = IOUtil.getClassNameFromDir(classDir, packageName);
        IOUtil.subClassFilter(allClassName, parentClassName, pool);
        return allClassName;
    }

    public static List<String> getSubType(String filepath, String packageName, String parentClassName, ClassPool pool) throws Exception {
        File tempfile = new File(filepath);
        if (tempfile.isDirectory()) {
            return IOUtil.getSubTypeFromDir(filepath, packageName, parentClassName, pool);
        }
        return IOUtil.getSubTypeFromJar("jar:file:" + (filepath.charAt(0) == '/' ? "" : "/") + filepath, packageName, parentClassName, pool);
    }

    public static void subClassFilter(List<String> allClassName, String parentClassName, ClassPool pool) throws NotFoundException {
        final ClassPool pooltrue = pool != null ? pool : ClassPool.getDefault();
        final CtClass superclassTrue = pool.get(parentClassName);
        CollectionUtils.filter(allClassName, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                try {
                    CtClass ctClass = pooltrue.get(String.valueOf(object));
                    if (ctClass.subtypeOf(superclassTrue)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
                return false;
            }
        });
    }

    public static Set<String> findSubClassByJars(final String parentClassName, int threadnum, Set<String> jars, final ClassPool pool) throws Exception {
        final HashSet<String> sublist = new HashSet<String>();
        if (CollectionUtils.isEmpty(jars)) {
            return sublist;
        }
        if (CollectionUtils.isEmpty(jars)) {
            return sublist;
        }
        if (threadnum <= 0) {
            threadnum = 1;
        }
        List<String> jarAry = Arrays.asList(jars.toArray(new String[jars.size()]));
        List<List<String>> inputlist = CollectionUtil.splitListN(jarAry, threadnum);
        ArrayList<FutureTask<Result>> furlist = new ArrayList<FutureTask<Result>>();
        for (final List<String> list : inputlist) {
            FutureTask<Result> aa = new FutureTask<Result>(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    for (String jarpath : list) {
                        try {
                            File file = new File(jarpath);
                            List<String> templist = IOUtil.getSubType(file.getPath(), null, parentClassName, pool);
                            sublist.addAll(templist);
                        }
                        catch (Exception e) {
                            return Result.getError(String.format("[%s]\u6267\u884c\u5931\u8d25", Thread.currentThread().getName()));
                        }
                    }
                    return Result.getSuc(String.format("[%s]\u6267\u884c\u6210\u529f", Thread.currentThread().getName()));
                }
            });
            furlist.add(aa);
            ThreadPool.getDefaultPool().submit(aa);
        }
        for (Future future : furlist) {
            if (((Result)future.get()).isSuc()) {
                log.info(((Result)future.get()).getMessage());
                continue;
            }
            log.info(((Result)future.get()).getMessage());
        }
        return sublist;
    }

    public static File getCurFolder(Class<?> classz, boolean isTarget) {
        URL url = classz.getProtectionDomain().getCodeSource().getLocation();
        String filePath = null;
        try {
            filePath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean isDelClass = false;
        if (filePath.endsWith(".jar")) {
            filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        } else if (isTarget) {
            isDelClass = true;
        }
        File file = new File(filePath);
        if (isDelClass) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getCurFolder(Class<?> classz) {
        return IOUtil.getCurFolder(classz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileReverse(String filename, int maxNum, String charset, boolean isKipnull) {
        RandomAccessFile rf = null;
        ArrayList<String> retlist = new ArrayList<String>();
        try {
            rf = new RandomAccessFile(filename, "r");
            long len = rf.length();
            long start = rf.getFilePointer();
            long nextend = start + len - 1L;
            rf.seek(nextend);
            int c = -1;
            while (nextend > start) {
                c = rf.read();
                if (c == 10 || c == 13) {
                    String line = rf.readLine();
                    if (line != null) {
                        retlist.add(new String(line.getBytes("ISO-8859-1"), charset));
                    } else if (!isKipnull) {
                        retlist.add("");
                    }
                    --nextend;
                }
                rf.seek(--nextend);
                if (nextend == 0L) {
                    retlist.add(new String(rf.readLine().getBytes("ISO-8859-1"), charset));
                }
                if (maxNum <= 0 || retlist.size() < maxNum - 1) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (rf != null) {
                    rf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retlist;
    }

    public static List<String> readFileReverse(String filename, int maxNum) {
        return IOUtil.readFileReverse(filename, maxNum, "UTF-8", true);
    }

    public static void createFile(String fileName, long fileSize) throws IOException {
        File newFile = new File(fileName);
        RandomAccessFile raf = new RandomAccessFile(newFile, "rw");
        raf.setLength(fileSize);
        raf.close();
    }

    public static Set<Class<?>> getClasses(String pack, boolean inSubPackage) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    IOUtil.findClassByFile(packageName, filePath, inSubPackage, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !inSubPackage || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findClassByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                IOUtil.findClassByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<URL> findHasPackRootPath(String packageName) {
        String packageDirName = packageName.replace('.', '/');
        ArrayList<URL> retRoots = new ArrayList<URL>();
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                String rootpath;
                int index;
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    index = url.getPath().indexOf("/classes/");
                    if (index <= 0) continue;
                    rootpath = url.getPath().substring(0, index + 9);
                    retRoots.add(new URL("file:" + rootpath));
                    continue;
                }
                if (!"jar".equals(protocol) || (index = url.getPath().lastIndexOf(".jar!/")) <= 0) continue;
                rootpath = url.getPath().substring(0, index + 6);
                retRoots.add(new URL("jar:" + rootpath));
            }
        }
        catch (IOException e) {
            log.error("\u67e5\u6839\u8def\u5f84\u9519\u8bef", (Throwable)e);
        }
        return retRoots;
    }
}

