/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.wicp.tams.commons.apiext.ReflectAssist;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.MVEL;

public abstract class CollectionUtil {
    public static String listJoin(List<?> fromList, String joinStr) {
        if (CollectionUtils.isEmpty(fromList)) {
            return null;
        }
        joinStr = StringUtils.isBlank((CharSequence)joinStr) ? "," : joinStr;
        StringBuffer toList = new StringBuffer();
        Iterator<?> iterator = fromList.iterator();
        toList.append(String.valueOf(iterator.next()));
        while (iterator.hasNext()) {
            String string = String.valueOf(iterator.next());
            toList.append(joinStr);
            toList.append(string);
        }
        return toList.toString();
    }

    public static String arrayJoin(Object[] fromList, String joinStr) {
        if (ArrayUtils.isEmpty((Object[])fromList)) {
            return null;
        }
        List<Object> objlist = Arrays.asList(fromList);
        return CollectionUtil.listJoin(objlist, joinStr);
    }

    public static <T> T[] arrayMerge(Class<T[]> clazz, T[] a, T[] b) {
        if (ArrayUtils.isEmpty((Object[])a)) {
            return b;
        }
        if (ArrayUtils.isEmpty((Object[])b)) {
            return a;
        }
        T[] newArray = CollectionUtil.newArrayByArrayClass(clazz, a.length + b.length);
        System.arraycopy(a, 0, newArray, 0, a.length);
        System.arraycopy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    public static <T> T[] newArrayByArrayClass(Class<T[]> clazz, int length) {
        return (Object[])Array.newInstance(clazz.getComponentType(), length);
    }

    public static <T> List<List<T>> splitList(List<T> inputList, int sumPerRow) {
        if (CollectionUtils.isEmpty(inputList) || sumPerRow == 0) {
            return null;
        }
        ArrayList<List<T>> returnList = new ArrayList<List<T>>();
        ArrayList<T> addList = new ArrayList<T>();
        for (int i = 0; i < inputList.size(); ++i) {
            if (i >= sumPerRow && i % sumPerRow == 0) {
                returnList.add(addList);
                addList = new ArrayList();
            }
            addList.add(inputList.get(i));
        }
        returnList.add(addList);
        return returnList;
    }

    public static <T> List<List<T>> splitListN(List<T> inputList, int listnum) {
        if (CollectionUtils.isEmpty(inputList) || listnum == 0) {
            return null;
        }
        int tempint = inputList.size() / listnum;
        if (tempint == 0) {
            ArrayList<List<T>> returnList = new ArrayList<List<T>>();
            returnList.add(inputList);
            return returnList;
        }
        List<List<T>> retlist = CollectionUtil.splitList(inputList.subList(0, tempint * listnum), tempint);
        int j = 0;
        for (int i = 0; i < inputList.size() % listnum; ++i) {
            retlist.get(j++).add(inputList.get(tempint * listnum + i));
        }
        return retlist;
    }

    public static List<?> getColFromObj(List<?> fromList, String colName) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (CollectionUtils.isEmpty(fromList)) {
            return retList;
        }
        for (Object object : fromList) {
            Object result = null;
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                Map tempObjMap = (Map)object;
                result = tempObjMap.get(colName);
            } else {
                result = MVEL.eval((String)colName, object);
            }
            retList.add(result);
        }
        return retList;
    }

    public static Collection selectFilter(Collection inputCollection, Predicate predicate) {
        Collection retCollection = CollectionUtils.select((Collection)inputCollection, (Predicate)predicate);
        CollectionUtils.filter((Collection)inputCollection, (Predicate)predicate);
        return retCollection;
    }

    public static void distinctFilter(Collection collection) {
        HashSet temps = new HashSet();
        temps.addAll(collection);
        collection.clear();
        collection.addAll(temps);
    }

    public static void filterNull(Map<String, String> orimap) {
        if (orimap == null) {
            return;
        }
        for (String key : orimap.keySet()) {
            if (!StringUtils.isBlank((CharSequence)orimap.get(key))) continue;
            orimap.remove(key);
        }
    }

    public static List filter(List oriList, final String colName, String include, String exclude) {
        ArrayList retAry = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)oriList)) {
            return retAry;
        }
        if (StringUtils.isNotBlank((CharSequence)include)) {
            String[] iAry = include.split(",");
            block2: for (int i = 0; i < iAry.length; ++i) {
                String includeValue = iAry[i];
                for (Object eleObj : oriList) {
                    try {
                        Object tempObj;
                        if (ReflectAssist.isInterface(eleObj.getClass(), "java.util.Map")) {
                            tempObj = (Map)eleObj;
                            if (!includeValue.equalsIgnoreCase(String.valueOf(tempObj.get(colName)))) continue;
                            retAry.add(eleObj);
                            continue block2;
                        }
                        tempObj = PropertyUtils.getProperty(eleObj, (String)colName);
                        if (!includeValue.equalsIgnoreCase(String.valueOf(tempObj))) continue;
                        retAry.add(eleObj);
                        continue block2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)exclude)) {
            final String[] eAry = exclude.split(",");
            retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
            CollectionUtils.filter(retAry, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    try {
                        Map tempObj;
                        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map") ? ArrayUtils.contains((Object[])eAry, (Object)String.valueOf((tempObj = (Map)object).get(colName))) : ArrayUtils.contains((Object[])eAry, (Object)(tempObj = PropertyUtils.getProperty((Object)object, (String)colName)))) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            });
        }
        retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
        return retAry;
    }

    public static List<Integer> asList(int[] oriAry) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (ArrayUtils.isNotEmpty((int[])oriAry)) {
            for (int integer : oriAry) {
                ret.add(integer);
            }
        }
        return ret;
    }

    public static List<Integer> asList(String[] oriAry) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (ArrayUtils.isNotEmpty((Object[])oriAry)) {
            for (String ele : oriAry) {
                ret.add(Integer.parseInt(ele));
            }
        }
        return ret;
    }

    public static List<String> asList(List<?> oriList) {
        if (oriList == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Object object : oriList) {
            ret.add(String.valueOf(object));
        }
        return ret;
    }

    public static Map<String, String> getPropsByKeypre(Properties prop, String keyPre) {
        if (prop == null || prop.size() == 0 || StringUtil.isNull(keyPre)) {
            return new HashMap<String, String>();
        }
        Set<Object> propKeys = prop.keySet();
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Object object : propKeys) {
            String tempStr = String.format("%s.", keyPre.endsWith(".") ? keyPre.substring(0, keyPre.length() - 1) : keyPre);
            String key = String.valueOf(object);
            if (!key.startsWith(tempStr)) continue;
            retMap.put(key, prop.getProperty(key));
        }
        return retMap;
    }

    public static Map newMap(Object ... input) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (ArrayUtils.isEmpty((Object[])input)) {
            return ret;
        }
        for (int i = 0; i < input.length / 2; ++i) {
            Object key = input[2 * i];
            Object value = 2 * i + 1 < input.length ? input[2 * i + 1] : null;
            ret.put(key, value);
        }
        return ret;
    }
}

