/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.commons.CallbackUpdate;
import net.wicp.tams.commons.apiext.CollectionUtil;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.constant.Encoding;
import net.wicp.tams.commons.constant.PathType;
import net.wicp.tams.commons.constant.StrPattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Conf {
    private static final Logger log = LoggerFactory.getLogger(Conf.class);
    private static final Properties props = new Properties();
    private static final Map<String[], CallbackUpdate> reshBacks = new HashMap<String[], CallbackUpdate>();
    private static Locale curLocale;

    public static void addFileFromJar(String propPath, Class classz) {
        Properties newprops = IOUtil.fileToProperties(propPath, classz);
        Conf.overProp(newprops);
    }

    public static void addCallBack(CallbackUpdate callbackupdate, String ... proNames) {
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])proNames), (String)"\u5fc5\u987b\u4f20\u8981\u8981\u68c0\u67e5\u53d8\u66f4\u7684\u5c5e\u6027\u503c", (Object[])new Object[0]);
        reshBacks.put(proNames, callbackupdate);
    }

    public static void addCallBack(CallbackUpdate callbackupdate, String pre) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)pre));
        Map<String, String> preprop = Conf.getPre(pre);
        Validate.isTrue((boolean)MapUtils.isNotEmpty(preprop), (String)("\u53d8\u91cf\u6ca1\u6709\u68c0\u67e5\u5230\uff0c\u8bf7\u68c0\u67e5[" + pre + "]\u5f00\u59cb\u7684\u5c5e\u6027\u662f\u5426\u6709\u914d\u7f6e"), (Object[])new Object[0]);
        Conf.addCallBack(callbackupdate, preprop.keySet().toArray(new String[preprop.size()]));
    }

    public static String get(String key) {
        return props.get(key) == null ? null : String.valueOf(props.get(key));
    }

    public static Map<String, String> getPre(String key) {
        return CollectionUtil.getPropsByKeypre(props, key);
    }

    public static void setCurLocale(Locale curLocale) {
        if (curLocale != null) {
            Conf.curLocale = curLocale;
        }
    }

    public static Locale getCurLocale() {
        return curLocale;
    }

    public static Properties copyProperties() {
        return (Properties)props.clone();
    }

    public static void overProp(Properties initProperties) {
        if (initProperties != null && initProperties.size() > 0) {
            for (Object keyobj : initProperties.keySet()) {
                props.put(keyobj, initProperties.get(keyobj));
            }
        }
    }

    public static Encoding getSystemEncode() {
        return Encoding.getByName(System.getProperty("sun.jnu.encoding"));
    }

    public static Encoding getFileEncode() {
        return Encoding.getByName(System.getProperty("file.encoding"));
    }

    static {
        String properPattern = "^common-([a-zA-z0-9]-*){1,}\\.properties$";
        FileAlterationMonitor monitor = new FileAlterationMonitor(1000L);
        RegexFileFilter fileFilter = new RegexFileFilter(properPattern);
        FileAlterationObserver observer = new FileAlterationObserver(new File(PathType.getPath(Conf.get("common.apiext.checkpath"))), (FileFilter)fileFilter);
        FileListerAdapter listener = new FileListerAdapter();
        observer.addListener((FileAlterationListener)listener);
        monitor.addObserver(observer);
        try {
            monitor.start();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u76d1\u63a7\u9519\u8bef", (Throwable)e);
        }
        List<URL> roots = IOUtil.findHasPackRootPath("net.wicp.tams");
        for (URL root : roots) {
            File[] files;
            if ("jar".equals(root.getProtocol())) {
                try {
                    Map<String, InputStream> is = IOUtil.getFilesFromJar(root.getPath(), ".", "properties");
                    for (String key : is.keySet()) {
                        if (key.contains("/common-") && key.contains(".jar")) {
                            String filepath = IOUtil.getCurFolder(Conf.class, false).getPath();
                            File file = new File(filepath);
                            if (!file.exists()) {
                                FileUtils.copyInputStreamToFile((InputStream)is.get(key), (File)file);
                            }
                            String filepathTrue = filepath.startsWith("file:") ? "jar:" + filepath : "jar:file:" + filepath;
                            Map<String, InputStream> map2 = IOUtil.getFilesFromJar(filepathTrue, ".", "properties");
                            System.out.println("\u52a0\u5de5\u7684\u6587\u4ef6\uff1a" + map2);
                            for (String key2 : map2.keySet()) {
                                if (!StrPattern.checkStrFormat(properPattern, key2)) continue;
                                Properties returnPro = new Properties();
                                returnPro.load(map2.get(key2));
                                Conf.overProp(returnPro);
                            }
                            continue;
                        }
                        if (!StrPattern.checkStrFormat(properPattern, key)) continue;
                        Properties returnPro = new Properties();
                        returnPro.load(is.get(key));
                        Conf.overProp(returnPro);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("\u52a0\u8f7dproperties\u9519\u8bef", (Throwable)e);
                    continue;
                }
            }
            if (!"file".equals(root.getProtocol())) continue;
            File dir = new File(root.getPath());
            for (File file : files = dir.listFiles((FileFilter)fileFilter)) {
                Properties properties = IOUtil.fileToProperties(file);
                Conf.overProp(properties);
            }
        }
        log.info("\u52a0\u8f7d\u914d\u7f6e\u9879:" + props.size());
        for (Object url : props.keySet()) {
            System.out.println("key======" + url);
        }
        curLocale = new Locale(Conf.get("common.apiext.i18n") == null ? "zh" : Conf.get("common.apiext.i18n"));
    }

    private static class FileListerAdapter
    extends FileAlterationListenerAdaptor {
        private FileListerAdapter() {
        }

        public void onFileChange(File file) {
            final Properties prop = IOUtil.fileToProperties(file);
            List selSet = (List)CollectionUtil.selectFilter(reshBacks.keySet(), new Predicate(){

                public boolean evaluate(Object object) {
                    Object[] tempary = (String[])object;
                    for (Object obj : prop.keySet()) {
                        if (!ArrayUtils.contains((Object[])tempary, (Object)obj)) continue;
                        return true;
                    }
                    return false;
                }
            });
            for (String[] sel : selSet) {
                ((CallbackUpdate)reshBacks.get(sel)).doReshConf(props, prop);
            }
            Conf.overProp(prop);
        }

        public void onFileCreate(File file) {
            Properties prop = IOUtil.fileToProperties(file);
            Conf.overProp(prop);
        }
    }
}

