package net.wicp.tams.commons.beans;

import lombok.Builder;
import lombok.Data;

/**
 * 主机
 * 
 *@author 偏锋书生
 *
 */
@Data
@Builder
public class Host implements Comparable<Host> {
	public final static String preVar = "host";

	private String hostName;
	private String hostIp;
	private int port;

	// db.tb
	// value为：col逗号分隔

	public Host() {
	}

	public Host(String hostName, String hostIp, int port) {
		super();
		this.hostName = hostName;
		this.hostIp = hostIp;
		this.port = port;
	}

	@Override
	public boolean equals(Object obj) {
		Host temp = (Host) obj;
		if (this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort()) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return hostIp.hashCode() * 37 + port;
	}

	@Override
	public int compareTo(Host o) {
		String[] ips1 = this.hostIp.split(".");
		String[] ips2 = o.getHostIp().split(".");
		for (int i = 0; i < 4; i++) {
			int si1 = Integer.parseInt(ips1[i]);
			int si2 = Integer.parseInt(ips2[i]);
			if (si1 != si2) {
				return si1 - si2;
			}
		}
		return this.port - o.getPort();
	}

}
