/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class InputStreamRamdomRead
extends InputStream {
    private final RandomAccessFile file;
    protected final File oriFile;
    protected long markPos = -1L;

    public InputStreamRamdomRead(File file) throws IOException {
        this.file = new RandomAccessFile(file, "r");
        this.oriFile = file;
    }

    @Override
    public int available() throws IOException {
        long fp = this.file.getFilePointer();
        return (int)(this.file.length() - fp);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPos = this.file.getFilePointer();
        }
        catch (IOException e) {
            this.markPos = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markPos >= 0L) {
            this.file.seek(this.markPos);
        }
    }

    public long getCurPos() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] r = new byte[length];
        this.read(r, 0, length);
        return r;
    }

    public byte readByte() throws IOException {
        return this.readBytes(1)[0];
    }
}

