package net.wicp.tams.commons.apiext.fastjson;

import org.apache.commons.lang3.ArrayUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;

public abstract class FastJsonUtil {
	/***
	 * 满足js对象格式的json字符串
	 * 
	 * @param object
	 * @param classes
	 * @return
	 */
	public static String toJSONString(Object object, Class... classes) {
		SerializeConfig config = new SerializeConfig();
		if (ArrayUtils.isNotEmpty(classes)) {
			SerializerJsonByJs addSerializer = new SerializerJsonByJs();
			for (Class class1 : classes) {
				config.put(class1, addSerializer);
			}
		}
		String jsonStr = JSON.toJSONString(object, config);
		return jsonStr;
	}
}
