/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.constant.dic;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.dic.intf.IEnumCombobox;

public enum SizeUnit implements IEnumCombobox
{
    b("bit", new String[]{"B,1/8", "KB,1/(8*1024)", "MB,1/(8*1024*1024)", "GB,1/(8*1024*1024*1024)", "TB,1/(8*1024*1024*1024*1024)"}),
    B("byte", new String[]{"b,8", "KB,1/1024", "MB,1/(1024*1024)", "GB,1/(1024*1024*1024)", "TB,1/(1024*1024*1024*1024)"}),
    KB("Kilobyte", new String[]{"b,8*1024", "B,1024", "MB,1/1024", "GB,1/(1024*1024)", "TB,1/(1024*1024*1024)"}),
    MB("Megabyte", new String[]{"b,8*1024*1024", "B,1024*1024", "KB,1024", "GB,1/1024", "TB,1/(1024*1024)"}),
    GB("Gigabyte", new String[]{"b,8*1024*1024*1024", "B,1024*1024*1024", "KB,1024*1024", "MB,1024", "TB,1/1024"}),
    TB("Terabyte", new String[]{"b,8*1024*1024*1024*1024", "B,1024*1024*1024*1024", "KB,1024*1024*1024", "MB,1024*1024", "GB,1024"});

    private final String desc;
    private final String[] convs;

    private SizeUnit(String desc, String[] convs) {
        this.desc = desc;
        this.convs = convs;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc() {
        return this.name();
    }

    @Override
    public String getDesc_en() {
        return this.desc;
    }

    @Override
    public String getDesc_zh() {
        return this.name();
    }

    public Double conv(SizeUnit sizeUnit) {
        for (String conv : this.convs) {
            String[] eles = conv.split(",");
            if (!eles[0].equals(sizeUnit.name())) continue;
            return (double)((Double)StringUtil.expr(eles[1], new String[0]));
        }
        return null;
    }

    public boolean includeUnit(String str) {
        String tempstr = StringUtil.hasNull(str);
        return tempstr.contains(this.name()) || tempstr.contains(this.name().replace("B", ""));
    }

    public String filter(String str) {
        if (StringUtil.isNull(str)) {
            return str;
        }
        return str.replace(this.name(), "").replace(this.name().replace("B", ""), "");
    }
}

