/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.DES;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PwdUtil {
    private static final Logger log = LoggerFactory.getLogger(PwdUtil.class);

    public static final String StringToBase64(String key) {
        return new String(Base64.encodeBase64((byte[])StringUtil.hexStringToBytes(key)));
    }

    public static final String Base64ToString(String key) {
        return StringUtil.bytesToHexString(Base64.decodeBase64((byte[])key.getBytes()));
    }

    public static final String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] strTemp = s.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            log.error("MD5\u52a0\u5bc6\u5931\u8d25");
            return null;
        }
    }

    private static byte[] GetKeyBytes(String strKey) throws Exception {
        int i;
        if (null == strKey || strKey.length() < 1) {
            throw new Exception("key is null or empty!");
        }
        MessageDigest alg = MessageDigest.getInstance("MD5");
        alg.update(strKey.getBytes(Conf.get("common.apiext.encode")));
        byte[] bkey = alg.digest();
        int start = bkey.length;
        byte[] bkey24 = new byte[24];
        for (i = 0; i < start; ++i) {
            bkey24[i] = bkey[i];
        }
        for (i = start; i < 24; ++i) {
            bkey24[i] = bkey[i - start];
        }
        return bkey24;
    }

    private static byte[] encryptMode(byte[] keybyte, byte[] src, DES des) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, des.name());
            Cipher c1 = Cipher.getInstance(des.name());
            c1.init(1, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e1) {
            log.error("\u52a0\u5bc6\u6570\u636e\u5931\u8d25", (Throwable)e1);
            return null;
        }
    }

    private static byte[] decryptMode(byte[] keybyte, byte[] src, DES des) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, des.name());
            Cipher c1 = Cipher.getInstance(des.name());
            c1.init(2, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String Encrypt3DES(String origValue, String key) {
        String str = null;
        try {
            str = Base64.encodeBase64String((byte[])PwdUtil.encryptMode(PwdUtil.GetKeyBytes(key), origValue.getBytes(Conf.get("common.apiext.encode")), DES.DESede));
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
        return str;
    }

    public static String Encrypt3DES(String origValue) {
        return PwdUtil.Encrypt3DES(origValue, Conf.get("common.apiext.threedes.key"));
    }

    public static String Decrypt3DES(String value, String key) {
        try {
            byte[] b = PwdUtil.decryptMode(PwdUtil.GetKeyBytes(key), new Base64().decode(value), DES.DESede);
            return new String(b);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String Decrypt3DES(String value) {
        return PwdUtil.Decrypt3DES(value, Conf.get("common.apiext.threedes.key"));
    }

    public static byte[] fromBase64(String p_Str) throws IOException {
        return Base64.decodeBase64((String)p_Str);
    }

    public static String toBase64(byte[] bPic) {
        return Base64.encodeBase64String((byte[])bPic);
    }

    public static byte[] md5(byte[] data) {
        return PwdUtil.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream is) throws IOException {
        return PwdUtil.digest(PwdUtil.getMd5Digest(), is);
    }

    public static byte[] sha(byte[] data) {
        return PwdUtil.getShaDigest().digest(data);
    }

    public static byte[] sha(InputStream is) throws IOException {
        return PwdUtil.digest(PwdUtil.getShaDigest(), is);
    }

    private static MessageDigest getMd5Digest() {
        return PwdUtil.getDigest("MD5");
    }

    private static MessageDigest getShaDigest() {
        return PwdUtil.getDigest("SHA");
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] digest(MessageDigest md, InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        int count = is.read(buffer);
        while (count > 0) {
            md.update(buffer, 0, count);
            count = is.read(buffer);
        }
        return md.digest();
    }
}

