package net.wicp.tams.commons.callback.impl.convertvalue;

import java.math.BigDecimal;

import net.wicp.tams.commons.apiext.NumberUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.commons.constant.dic.SizeUnit;

public class ConvertValueSize implements IConvertValue<String> {
	private final SizeUnit toUnit;// 要转的单位
	private final SizeUnit fromUnit;
	private final int scale;

	public ConvertValueSize(SizeUnit fromSizeUnit, SizeUnit toSizeUnit, Integer scale) {
		this.fromUnit = fromSizeUnit;
		this.toUnit = toSizeUnit;
		if (scale == null) {
			this.scale = 2;
		} else {
			this.scale = scale;
		}
	}

	public ConvertValueSize(SizeUnit fromSizeUnit, SizeUnit toSizeUnit) {
		this(fromSizeUnit, toSizeUnit, null);
	}

	@Override
	public String getStr(String keyObj) {
		if (StringUtil.isNull(keyObj)) {
			return "";
		}
		Double temp = fromUnit.conv(toUnit);// Long.parseLong(fromUnit.filter(keyObj));
		keyObj = fromUnit.filter(keyObj);
		Double db = Double.parseDouble(keyObj);
		Double retdb = db * temp;
		BigDecimal retBig = NumberUtil.handleScale(retdb, scale);
		return retBig.doubleValue() + toUnit.name();
	}

}
