/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.net.InetAddress;
import java.security.SecureRandom;

public class UUIDGenerator {
    private static SecureRandom seederStatic = null;
    private static byte[] addr = null;
    private static String midValueStatic = null;
    private String midValue = null;
    private SecureRandom seeder = null;
    private static long prevMillis = 0L;
    private static byte[] addrBytes = null;

    public UUIDGenerator() {
        StringBuffer buffer = new StringBuffer(16);
        buffer.append(midValueStatic);
        buffer.append(UUIDGenerator.toHex(System.identityHashCode(this), 8));
        this.midValue = buffer.toString();
        this.seeder = new SecureRandom();
        this.seeder.nextInt();
    }

    public static String generate(Object obj) {
        StringBuffer uid = new StringBuffer(32);
        long currentTimeMillis = System.currentTimeMillis();
        uid.append(UUIDGenerator.toHex((int)(currentTimeMillis & 0xFFFFFFFFFFFFFFFFL), 8));
        uid.append(midValueStatic);
        uid.append(UUIDGenerator.toHex(System.identityHashCode(obj), 8));
        uid.append(UUIDGenerator.toHex(UUIDGenerator.getRandom(), 8));
        return uid.toString();
    }

    public String generate() {
        StringBuffer uid = new StringBuffer(32);
        long currentTimeMillis = System.currentTimeMillis();
        uid.append(UUIDGenerator.toHex((int)(currentTimeMillis & 0xFFFFFFFFFFFFFFFFL), 8));
        uid.append(this.midValue);
        uid.append(UUIDGenerator.toHex(this.seeder.nextInt(), 8));
        return uid.toString();
    }

    private static String toHex(int value, int length) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buffer = new StringBuffer(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(hexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            value |= bytes[i];
        }
        return value;
    }

    private static synchronized int getRandom() {
        return seederStatic.nextInt();
    }

    private static synchronized long getSystemTimeMillis() {
        long millis = System.currentTimeMillis();
        prevMillis = millis > prevMillis ? millis : ++prevMillis;
        return prevMillis;
    }

    public static Long getUniqueLong() {
        long l = UUIDGenerator.getSystemTimeMillis();
        l *= 1000L;
        long b1 = addrBytes[3] & 0xFF;
        return l += b1;
    }

    static {
        try {
            addr = InetAddress.getLocalHost().getAddress();
            addrBytes = InetAddress.getLocalHost().getAddress();
            StringBuffer buffer = new StringBuffer(8);
            buffer.append(UUIDGenerator.toHex(UUIDGenerator.toInt(addr), 8));
            midValueStatic = buffer.toString();
            seederStatic = new SecureRandom();
            seederStatic.nextInt();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

