/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.callback.impl.convertvalue;

import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.commons.constant.dic.intf.IEnumCombobox;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ConvertValueEnum
implements IConvertValue<String> {
    private Object[] objs;
    private String lan;

    public ConvertValueEnum(Object[] obj, String lan) {
        this.objs = obj;
        this.lan = lan;
    }

    public ConvertValueEnum(Class classobj, String lan) {
        this.objs = classobj.getEnumConstants();
        this.lan = lan;
    }

    public ConvertValueEnum(String className, String lan) {
        try {
            Class<?> classobj = Class.forName(className);
            this.objs = classobj.getEnumConstants();
            this.lan = lan;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public String getStr(String key) {
        String retvalue;
        if (StringUtil.isNull(key) || ArrayUtils.isEmpty((Object[])this.objs)) {
            return key;
        }
        IEnumCombobox curobj = null;
        for (Object object : this.objs) {
            IEnumCombobox tempobj = (IEnumCombobox)object;
            if (!key.equals(tempobj.getName())) continue;
            curobj = tempobj;
            break;
        }
        if (curobj == null) {
            return key;
        }
        String filed = StringUtil.isNull(this.lan) ? "desc" : String.format("desc_%s", this.lan);
        try {
            retvalue = BeanUtils.getSimpleProperty(curobj, (String)filed);
        }
        catch (Exception e) {
            retvalue = key;
        }
        return retvalue;
    }
}

