/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtil {
    private static final Logger log = LoggerFactory.getLogger(TarUtil.class);

    public static void compress(String tarFilePath, String directory) {
        File tarFile = new File(tarFilePath);
        if (!tarFile.exists()) {
            throw new RuntimeException("tar file is not exists.");
        }
        if (!tarFile.isFile()) {
            throw new RuntimeException("compress file is not a file.");
        }
        try {
            FileInputStream ins = new FileInputStream(tarFile);
            TarUtil.compress(ins, directory);
        }
        catch (FileNotFoundException e) {
            log.error("\u6ca1\u6709\u8fd9\u4e2a\u6587\u4ef6:{}", (Object)tarFilePath);
        }
    }

    public static void compress(String tarFilePath) {
        tarFilePath = tarFilePath.replace("\\", "/");
        int index = tarFilePath.lastIndexOf("/");
        TarUtil.compress(tarFilePath, tarFilePath.substring(0, index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(InputStream is, String directory) {
        TarArchiveInputStream in = null;
        try {
            in = new TarArchiveInputStream(is, "utf-8");
            TarArchiveEntry entry = in.getNextTarEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    entry = in.getNextTarEntry();
                    continue;
                }
                File curfile = new File(directory, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (OutputStream out = null;){
                    out = new FileOutputStream(curfile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    entry = in.getNextTarEntry();
                }
            }
            in.close();
        }
        catch (Exception e) {
            log.error("compress tar error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
        }
    }

    public static void compress(byte[] bytes, String directory) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        TarUtil.compress(bais, directory);
    }
}

