package net.wicp.tams.commons.constant;

import net.wicp.tams.commons.apiext.StringUtil;

/****
 * 环境枚举
 * 
 * @author zhoujunhui
 *
 */
public enum Env {
	dev("开发环境"), test("测试环境"), pre("预发环境"), prd("生产环境");

	private final String desc;

	private Env(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public static Env getByName(String env,Env defaultEnv) {
		if (StringUtil.isNull(env)) {// 默认是任意匹配
			return defaultEnv;
		}
		for (Env ele : Env.values()) {
			if (env.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return defaultEnv;
	}

}
