/*
 * Copyright 2015 Zhongan.com All right reserved. This software is the
 * confidential and proprietary information of Zhongan.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with Zhongan.com.
 */
package net.wicp.tams.commons.apiext;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;

/****
 * 
 * @author zhoujunhui
 *
 */
@Slf4j
public class TarUtil {

	/***
	 * 解压tar文件
	 * 
	 * @param tarFilePath
	 *            tar的路径
	 * @param directory
	 *            解压后的存放路径
	 */
	public static void compress(String tarFilePath, String directory) {

		File tarFile = new File(tarFilePath);
		if (!tarFile.exists()) {
			throw new RuntimeException("tar file is not exists.");
		}

		if (!tarFile.isFile()) {
			throw new RuntimeException("compress file is not a file.");
		}
		try {
			InputStream ins = new FileInputStream(tarFile);
			compress(ins, directory);
		} catch (FileNotFoundException e) {
			log.error("没有这个文件:{}", tarFilePath);
		}
	}

	/***
	 * 解压tar到当前目录下
	 * 
	 * @param tarFilePath
	 *            tar文件的路径
	 */
	public static void compress(String tarFilePath) {
		tarFilePath = tarFilePath.replace("\\", "/");
		int index = tarFilePath.lastIndexOf("/");
		compress(tarFilePath, tarFilePath.substring(0, index));
	}

	public static void compress(InputStream is, String directory) {
		TarArchiveInputStream in = null;
		try {
			in = new TarArchiveInputStream(is, "utf-8");
			TarArchiveEntry entry = in.getNextTarEntry();
			while (entry != null) {
				if (entry.isDirectory()) {
					entry = in.getNextTarEntry();
					continue;
				}
				File curfile = new File(directory, entry.getName());
				File parent = curfile.getParentFile();
				if (!parent.exists()) {
					parent.mkdirs();
				}
				OutputStream out = null;
				try {
					out = new FileOutputStream(curfile);
					IOUtils.copy(in, out);
					entry = in.getNextTarEntry();
				} finally {
					out.close();
				}
			}
			in.close();

		} catch (Exception e) {
			log.error("compress tar error.", e);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
					log.error("compress tar error.", e);
				}
			}
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					log.error("compress tar error.", e);
				}
			}
		}
	}

	public static void compress(byte[] bytes, String directory) {
		ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
		compress(bais, directory);
	}

}
