/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.ali;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.FileUtils;

import com.aliyun.oss.model.OSSObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.ali.oss.OssClientTams;
import net.wicp.tams.common.callback.IRemote;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public class TamsRemoteImpl implements IRemote {
	// eg:oss://dev-xforceplus-mq/duckula/plugins/duckula-plugin-es5.tar
	@Override
	public InputStream findStream(String path) {
		String pathtrue = path.replace("oss:", "").replace("//", "/");
		OssClientTams ossClient = AliClientManager.getInst().getOssClient();
		OSSObject object = ossClient.getObjectByBucketNameKey(pathtrue);		
		return object.getObjectContent();
	}

	@Override
	public void findStream(String path, String localPath) {
		try {
			FileUtils.copyInputStreamToFile(findStream(path), new File(localPath));
		} catch (IOException e) {
			log.error("取OSS文件错误", e);
			throw new ProjectExceptionRuntime(ExceptAll.project_undefined, "取OSS文件错误");
		}
	}

}
