/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.ali;

import net.wicp.tams.common.ali.oss.OssClientTams;

public class AliClientManager {
	private static volatile AliClientManager aliClientOnlyOne;
	private final OssClientTams ossClient;

	public OssClientTams getOssClient() {
		return ossClient;
	}

	private AliClientManager() {
		this.ossClient = OssClientTams.getInst();

	}

	public static AliClientManager getInst() {
		if (aliClientOnlyOne == null) {
			synchronized (AliClientManager.class) {
				if (aliClientOnlyOne == null) {
					aliClientOnlyOne = new AliClientManager();
				}
			}
		}
		return aliClientOnlyOne;
	}

}
